/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;

public class NonTaggedGetItemResultType
extends AbstractResultTypeComputer {
    public static final NonTaggedGetItemResultType INSTANCE = new NonTaggedGetItemResultType();

    private NonTaggedGetItemResultType() {
    }

    @Override
    protected void checkArgType(String funcName, int argIndex, IAType type) throws AlgebricksException {
        ATypeTag actualTypeTag = type.getTypeTag();
        if (argIndex == 0) {
            if (type.getTypeTag() != ATypeTag.UNORDEREDLIST && type.getTypeTag() != ATypeTag.ORDEREDLIST) {
                throw new TypeMismatchException(funcName, (Integer)argIndex, actualTypeTag, ATypeTag.STRING, ATypeTag.ORDEREDLIST);
            }
        } else if (!ATypeHierarchy.isCompatible(type.getTypeTag(), ATypeTag.INT32)) {
            throw new TypeMismatchException(funcName, (Integer)argIndex, actualTypeTag, ATypeTag.INT32);
        }
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType type = strippedInputTypes[0];
        if (type.getTypeTag() == ATypeTag.ANY) {
            return BuiltinType.ANY;
        }
        IAType itemType = ((AbstractCollectionType)type).getItemType();
        if (itemType.getTypeTag() == ATypeTag.ANY) {
            return itemType;
        }
        return AUnionType.createUnknownableType(itemType);
    }
}

