/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.TypeMismatchException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class FieldAccessByIndexResultType
extends AbstractResultTypeComputer {
    public static final FieldAccessByIndexResultType INSTANCE = new FieldAccessByIndexResultType();

    private FieldAccessByIndexResultType() {
    }

    @Override
    protected void checkArgType(String funcName, int argIndex, IAType type) throws AlgebricksException {
        ATypeTag actualTypeTag = type.getTypeTag();
        if (argIndex == 0 && actualTypeTag != ATypeTag.RECORD) {
            throw new TypeMismatchException(funcName, (Integer)argIndex, actualTypeTag, ATypeTag.RECORD);
        }
        if (argIndex == 1 && actualTypeTag != ATypeTag.INT32) {
            throw new TypeMismatchException(funcName, (Integer)argIndex, actualTypeTag, ATypeTag.INT32);
        }
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        IAType firstArgType = strippedInputTypes[0];
        if (firstArgType.getTypeTag() != ATypeTag.RECORD) {
            return BuiltinType.ANY;
        }
        AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
        Integer pos = ConstantExpressionUtil.getIntArgument(funcExpr, 1);
        if (pos == null) {
            return BuiltinType.ANY;
        }
        ARecordType recType = (ARecordType)firstArgType;
        return recType.getFieldTypes()[pos];
    }
}

