/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.base;

import org.apache.asterix.om.exceptions.IncompatibleTypeException;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;

public class TypeCastUtils {
    private TypeCastUtils() {
    }

    public static boolean setRequiredAndInputTypes(AbstractFunctionCallExpression expr, IAType requiredType, IAType inputType) throws AlgebricksException {
        boolean changed = false;
        Object[] opaqueParameters = expr.getOpaqueParameters();
        if (opaqueParameters == null) {
            ATypeTag actualTypeTag;
            opaqueParameters = new Object[]{requiredType, inputType};
            ATypeTag requiredTypeTag = requiredType.getTypeTag();
            if (!ATypeHierarchy.isCompatible(requiredTypeTag, actualTypeTag = TypeComputeUtils.getActualType(inputType).getTypeTag())) {
                String funcName = expr.getFunctionIdentifier().getName();
                throw new IncompatibleTypeException(funcName, actualTypeTag, requiredTypeTag);
            }
            expr.setOpaqueParameters(opaqueParameters);
            changed = true;
        }
        return changed;
    }

    public static void resetRequiredAndInputTypes(AbstractFunctionCallExpression expr) {
        expr.setOpaqueParameters(null);
    }

    public static IAType getRequiredType(AbstractFunctionCallExpression expr) {
        Object[] type = expr.getOpaqueParameters();
        if (type != null) {
            IAType returnType = (IAType)type[0];
            return returnType;
        }
        return null;
    }
}

