/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.printer;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.printer.IPrintVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class ARecordPrinter {
    private final String startRecord;
    private final String endRecord;
    private final String fieldSeparator;
    private final String fieldNameSeparator;
    private final Pair<PrintStream, ATypeTag> nameVisitorArg = new Pair(null, (Object)ATypeTag.STRING);
    private final Pair<PrintStream, ATypeTag> itemVisitorArg = new Pair(null, null);

    public ARecordPrinter(String startRecord, String endRecord, String fieldSeparator, String fieldNameSeparator) {
        this.startRecord = startRecord;
        this.endRecord = endRecord;
        this.fieldSeparator = fieldSeparator;
        this.fieldNameSeparator = fieldNameSeparator;
    }

    public void printRecord(ARecordVisitablePointable recordAccessor, PrintStream ps, IPrintVisitor visitor) throws IOException, AsterixException {
        List<IVisitablePointable> fieldNames = recordAccessor.getFieldNames();
        List<IVisitablePointable> fieldValues = recordAccessor.getFieldValues();
        this.nameVisitorArg.first = ps;
        this.itemVisitorArg.first = ps;
        ps.print(this.startRecord);
        int size = fieldNames.size();
        IVisitablePointable fieldValue = size > 0 ? fieldValues.get(0) : null;
        ATypeTag typeTag = fieldValue != null ? EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(fieldValue.getByteArray()[fieldValue.getStartOffset()]) : null;
        for (int i = 0; i < size; ++i) {
            IVisitablePointable fieldName = fieldNames.get(i);
            if (typeTag != ATypeTag.MISSING) {
                this.printField(ps, visitor, fieldName, fieldValue, typeTag);
            }
            if (i >= size - 1) continue;
            fieldValue = fieldValues.get(i + 1);
            ATypeTag nextTypeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(fieldValue.getByteArray()[fieldValue.getStartOffset()]);
            if ((i != 0 || typeTag != ATypeTag.MISSING) && nextTypeTag != ATypeTag.MISSING) {
                ps.print(this.fieldSeparator);
            }
            typeTag = nextTypeTag;
        }
        ps.print(this.endRecord);
    }

    private void printField(PrintStream ps, IPrintVisitor visitor, IVisitablePointable fieldName, IVisitablePointable fieldValue, ATypeTag fieldTypeTag) throws AsterixException {
        this.itemVisitorArg.second = fieldTypeTag;
        if (this.fieldNameSeparator != null) {
            fieldName.accept(visitor, this.nameVisitorArg);
            ps.print(this.fieldNameSeparator);
        }
        fieldValue.accept(visitor, this.itemVisitorArg);
    }
}

