/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.printer;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.printer.IPrintVisitor;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.hyracks.algebricks.common.utils.Pair;

public class AListPrinter {
    private final String startList;
    private final String endList;
    private final String separator;
    private final Pair<PrintStream, ATypeTag> itemVisitorArg = new Pair(null, null);

    public AListPrinter(String startList, String endList, String separator) {
        this.startList = startList;
        this.endList = endList;
        this.separator = separator;
    }

    public void printList(AListVisitablePointable listAccessor, PrintStream ps, IPrintVisitor visitor) throws IOException, AsterixException {
        List<IVisitablePointable> itemTags = listAccessor.getItemTags();
        List<IVisitablePointable> items = listAccessor.getItems();
        this.itemVisitorArg.first = ps;
        ps.print(this.startList);
        int size = items.size();
        for (int i = 0; i < size - 1; ++i) {
            this.printItem(visitor, itemTags, items, i);
            ps.print(this.separator);
        }
        if (size > 0) {
            this.printItem(visitor, itemTags, items, size - 1);
        }
        ps.print(this.endList);
    }

    private void printItem(IPrintVisitor visitor, List<IVisitablePointable> itemTags, List<IVisitablePointable> items, int i) throws AsterixException {
        IVisitablePointable itemTypeTag = itemTags.get(i);
        IVisitablePointable item = items.get(i);
        ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(itemTypeTag.getByteArray()[itemTypeTag.getStartOffset()]);
        this.itemVisitorArg.second = item.getLength() <= 1 ? ATypeTag.NULL : typeTag;
        item.accept(visitor, this.itemVisitorArg);
    }
}

