/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public class ARectangle
implements IAObject {
    protected APoint p1;
    protected APoint p2;

    public ARectangle(APoint p1, APoint p2) {
        this.p1 = p1;
        this.p2 = p2;
    }

    public APoint getP1() {
        return this.p1;
    }

    public APoint getP2() {
        return this.p2;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ARECTANGLE;
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitARectangle(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof ARectangle)) {
            return false;
        }
        ARectangle x = (ARectangle)obj;
        return this.p1.deepEqual(x.p1) && this.p2.deepEqual(x.p2);
    }

    @Override
    public int hash() {
        return this.p1.hash() + 31 * this.p2.hash();
    }

    public String toString() {
        return "ARectangle: { p1: " + this.p1 + ", p2: " + this.p2 + "}";
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ObjectNode rectangle = om.createObjectNode();
        rectangle.set("p1", (JsonNode)this.p1.toJSON());
        rectangle.set("p2", (JsonNode)this.p2.toJSON());
        json.set("ARectangle", (JsonNode)rectangle);
        return json;
    }
}

