/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public class ADouble
implements IAObject {
    protected double value;

    public ADouble(double value) {
        this.value = value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ADOUBLE;
    }

    public String toString() {
        return "ADouble: {" + this.value + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ADouble)) {
            return false;
        }
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((ADouble)obj).getDoubleValue());
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitADouble(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("ADouble", this.value);
        return json;
    }
}

