/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public class ADate
implements IAObject {
    protected int chrononTimeInDay;
    protected static long CHRONON_OF_DAY = 86400000L;

    public ADate(int chrononTimeInDay) {
        this.chrononTimeInDay = chrononTimeInDay;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ADATE;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ADate)) {
            return false;
        }
        return ((ADate)o).chrononTimeInDay == this.chrononTimeInDay;
    }

    public int hashCode() {
        return this.chrononTimeInDay;
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitADate(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        StringBuilder sbder = new StringBuilder();
        sbder.append("ADate: { ");
        try {
            GregorianCalendarSystem.getInstance().getExtendStringRepUntilField((long)this.chrononTimeInDay * CHRONON_OF_DAY, 0, sbder, GregorianCalendarSystem.Fields.YEAR, GregorianCalendarSystem.Fields.DAY, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        sbder.append(" }");
        return sbder.toString();
    }

    public int getChrononTimeInDays() {
        return this.chrononTimeInDay;
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        json.put("ADate", this.chrononTimeInDay);
        return json;
    }
}

