/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public final class ABoolean
implements IAObject {
    public static final ABoolean TRUE = new ABoolean(true);
    public static final ABoolean FALSE = new ABoolean(false);
    private final Boolean bVal;

    private ABoolean(boolean b) {
        this.bVal = b;
    }

    public Boolean getBoolean() {
        return this.bVal;
    }

    public static ABoolean valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ABOOLEAN;
    }

    public String toString() {
        return "ABoolean: {" + this.bVal + "}";
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return this.bVal.hashCode();
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitABoolean(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return obj == this;
    }

    @Override
    public int hash() {
        return this.bVal.hashCode();
    }

    public ObjectNode toJSON() {
        return new ObjectMapper().createObjectNode().put("ABoolean", this.bVal);
    }
}

