/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.visitors.IOMVisitor;

public final class ABitArray
implements IAObject {
    private int numberOfBits;
    private int[] intArray;

    public ABitArray(int nBits) {
        this.numberOfBits = nBits;
        this.intArray = new int[nBits / 32 + 1];
    }

    public int[] getIntArray() {
        return this.intArray;
    }

    public final boolean get(int index) {
        int q = index / 32;
        int r = index % 32;
        int p = 1 << r;
        return (this.intArray[q] & p) != 0;
    }

    public final int numberOfBits() {
        return this.numberOfBits;
    }

    public final void set(int index, boolean value) {
        int r = index % 32;
        int q = index / 32;
        int p = 1 << r;
        if (value) {
            int n = q;
            this.intArray[n] = this.intArray[n] | p;
        } else {
            int n = q;
            this.intArray[n] = this.intArray[n] & (p ^= 0xFFFFFFFF);
        }
    }

    public final void setBit(int index) {
        this.set(index, true);
    }

    @Override
    public IAType getType() {
        return BuiltinType.ABITARRAY;
    }

    public void or(ABitArray bitArray) {
        int n2 = bitArray.numberOfBits();
        int[] a2 = bitArray.getIntArray();
        int q = n2 / 32;
        for (int i = 0; i < q; ++i) {
            int n = i;
            this.intArray[n] = this.intArray[n] | a2[i];
        }
        int r = n2 % 32;
        if (r > 0) {
            int mask = 0;
            for (int i = 0; i < r; ++i) {
                mask = (mask << 1) + 1;
            }
            int n = q;
            this.intArray[n] = this.intArray[n] | a2[q] & mask;
        }
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.intArray.length; ++i) {
            h = h * 31 + this.intArray[i];
        }
        return h;
    }

    @Override
    public void accept(IOMVisitor visitor) throws AsterixException {
        visitor.visitABitArray(this);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        if (!(obj instanceof ABitArray)) {
            return false;
        }
        int[] x = ((ABitArray)obj).getIntArray();
        if (this.intArray.length != x.length) {
            return false;
        }
        for (int k = 0; k < this.intArray.length; ++k) {
            if (this.intArray[k] == x[k]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ABitArray: [ ");
        for (int i = 0; i < this.intArray.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.intArray[i]);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ArrayNode bitArray = om.createArrayNode();
        for (int i = 0; i < this.intArray.length; ++i) {
            bitArray.add(this.intArray[i]);
        }
        json.set("ABitArray", (JsonNode)bitArray);
        return json;
    }
}

