/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.formats.nontagged;

import java.io.Serializable;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.data.ILinearizeComparatorFactoryProvider;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparator;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.rtree.linearize.HilbertDoubleComparatorFactory;
import org.apache.hyracks.storage.am.rtree.linearize.ZCurveDoubleComparatorFactory;
import org.apache.hyracks.storage.am.rtree.linearize.ZCurveIntComparatorFactory;

public class LinearizeComparatorFactoryProvider
implements ILinearizeComparatorFactoryProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final LinearizeComparatorFactoryProvider INSTANCE = new LinearizeComparatorFactoryProvider();

    private LinearizeComparatorFactoryProvider() {
    }

    public ILinearizeComparatorFactory getLinearizeComparatorFactory(Object type, boolean ascending, int dimension) throws AlgebricksException {
        ATypeTag typeTag = (ATypeTag)type;
        if (dimension == 2 && typeTag == ATypeTag.DOUBLE) {
            return this.addOffset((IBinaryComparatorFactory)new HilbertDoubleComparatorFactory(2), ascending);
        }
        if (typeTag == ATypeTag.DOUBLE) {
            return this.addOffset((IBinaryComparatorFactory)new ZCurveDoubleComparatorFactory(dimension), ascending);
        }
        if (typeTag == ATypeTag.INT8 || typeTag == ATypeTag.INT16 || typeTag == ATypeTag.INT32 || typeTag == ATypeTag.INT64) {
            return this.addOffset((IBinaryComparatorFactory)new ZCurveIntComparatorFactory(dimension), ascending);
        }
        throw new AlgebricksException("Cannot propose linearizer for key with type " + typeTag + " and dimension " + dimension + ".");
    }

    private ILinearizeComparatorFactory addOffset(final IBinaryComparatorFactory inst, final boolean ascending) {
        return new ILinearizeComparatorFactory(){
            private static final long serialVersionUID = 1L;

            public ILinearizeComparator createBinaryComparator() {
                final ILinearizeComparator bc = (ILinearizeComparator)inst.createBinaryComparator();
                final int dimension = bc.getDimensions();
                if (ascending) {
                    return new ILinearizeComparator(){

                        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                            return bc.compare(b1, s1 + 1, l1, b2, s2 + 1, l2);
                        }

                        public int getDimensions() {
                            return dimension;
                        }
                    };
                }
                return new ILinearizeComparator(){

                    public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                        return -bc.compare(b1, s1 + 1, l1, b2, s2 + 1, l2);
                    }

                    public int getDimensions() {
                        return dimension;
                    }
                };
            }
        };
    }
}

