/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.Coordinate;
import org.apache.asterix.om.base.APoint3D;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class APoint3DSerializerDeserializer
implements ISerializerDeserializer<APoint3D> {
    private static final long serialVersionUID = 1L;
    public static final APoint3DSerializerDeserializer INSTANCE = new APoint3DSerializerDeserializer();

    private APoint3DSerializerDeserializer() {
    }

    public APoint3D deserialize(DataInput in) throws HyracksDataException {
        try {
            return new APoint3D(in.readDouble(), in.readDouble(), in.readDouble());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(APoint3D instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeDouble(instance.getX());
            out.writeDouble(instance.getY());
            out.writeDouble(instance.getZ());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static void stringToPoint3d(String instance, DataOutput out) throws HyracksDataException {
        try {
            int firstCommaIndex = instance.indexOf(44);
            int secondCommaIndex = instance.indexOf(44, firstCommaIndex + 1);
            out.writeByte(ATypeTag.POINT3D.serialize());
            out.writeDouble(Double.parseDouble(instance.substring(0, firstCommaIndex)));
            out.writeDouble(Double.parseDouble(instance.substring(firstCommaIndex + 1, secondCommaIndex)));
            out.writeDouble(Double.parseDouble(instance.substring(secondCommaIndex + 1, instance.length())));
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public static final int getCoordinateOffset(Coordinate coordinate) throws HyracksDataException {
        switch (coordinate) {
            case X: {
                return 1;
            }
            case Y: {
                return 9;
            }
            case Z: {
                return 17;
            }
        }
        throw new HyracksDataException("Wrong coordinate");
    }
}

