/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.om.base.ADouble;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class ADoubleSerializerDeserializer
implements ISerializerDeserializer<ADouble> {
    private static final long serialVersionUID = 1L;
    public static final ADoubleSerializerDeserializer INSTANCE = new ADoubleSerializerDeserializer();

    private ADoubleSerializerDeserializer() {
    }

    public ADouble deserialize(DataInput in) throws HyracksDataException {
        try {
            return new ADouble(in.readDouble());
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void serialize(ADouble instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeDouble(instance.getDoubleValue());
        }
        catch (IOException ioe) {
            throw new HyracksDataException((Throwable)ioe);
        }
    }

    public static double getDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(ADoubleSerializerDeserializer.getLongBits(bytes, offset));
    }

    public static long getLongBits(byte[] bytes, int offset) {
        return AInt64SerializerDeserializer.getLong(bytes, offset);
    }
}

