/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.comparators.ABinaryComparator;
import org.apache.asterix.dataflow.data.nontagged.comparators.ACirclePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ADurationPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalAscPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ALinePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APoint3DPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APointPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APolygonPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ARectanglePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AUUIDPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.BooleanBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.LongBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.RawBinaryComparatorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.DoublePointable;
import org.apache.hyracks.data.std.primitive.FloatPointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.ShortPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class AObjectAscBinaryComparatorFactory
implements IBinaryComparatorFactory {
    private static final long serialVersionUID = 1L;
    public static final AObjectAscBinaryComparatorFactory INSTANCE = new AObjectAscBinaryComparatorFactory();

    private AObjectAscBinaryComparatorFactory() {
    }

    public IBinaryComparator createBinaryComparator() {
        return new ABinaryComparator(){
            private ArrayBackedValueStorage castBuffer = new ArrayBackedValueStorage();
            private ITypeConvertComputer promoteComputer;
            final IBinaryComparator ascBoolComp = BooleanBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascByteComp = new PointableBinaryComparatorFactory(BytePointable.FACTORY).createBinaryComparator();
            final IBinaryComparator ascShortComp = new PointableBinaryComparatorFactory(ShortPointable.FACTORY).createBinaryComparator();
            final IBinaryComparator ascIntComp = new PointableBinaryComparatorFactory(IntegerPointable.FACTORY).createBinaryComparator();
            final IBinaryComparator ascLongComp = LongBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascStrComp = new PointableBinaryComparatorFactory(UTF8StringPointable.FACTORY).createBinaryComparator();
            final IBinaryComparator ascByteArrayComp = new PointableBinaryComparatorFactory(ByteArrayPointable.FACTORY).createBinaryComparator();
            final IBinaryComparator ascFloatComp = new PointableBinaryComparatorFactory(FloatPointable.FACTORY).createBinaryComparator();
            final IBinaryComparator ascDoubleComp = new PointableBinaryComparatorFactory(DoublePointable.FACTORY).createBinaryComparator();
            final IBinaryComparator ascRectangleComp = ARectanglePartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascCircleComp = ACirclePartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascDurationComp = ADurationPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascIntervalComp = AIntervalAscPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascLineComp = ALinePartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascPointComp = APointPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascPoint3DComp = APoint3DPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascPolygonComp = APolygonPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator ascUUIDComp = AUUIDPartialBinaryComparatorFactory.INSTANCE.createBinaryComparator();
            final IBinaryComparator rawComp = RawBinaryComparatorFactory.INSTANCE.createBinaryComparator();

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) throws HyracksDataException {
                if (b1[s1] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                    if (b2[s2] != ATypeTag.SERIALIZED_MISSING_TYPE_TAG) return -1;
                    return 0;
                }
                if (b2[s2] == ATypeTag.SERIALIZED_MISSING_TYPE_TAG) {
                    return 1;
                }
                if (b1[s1] == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                    if (b2[s2] != ATypeTag.SERIALIZED_NULL_TYPE_TAG) return -1;
                    return 0;
                }
                if (b2[s2] == ATypeTag.SERIALIZED_NULL_TYPE_TAG) {
                    return 1;
                }
                ATypeTag tag1 = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(b1[s1]);
                ATypeTag tag2 = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(b2[s2]);
                if (tag1 == null) return this.rawComp.compare(b1, s1, l1, b2, s2, l2);
                if (tag2 == null) {
                    return this.rawComp.compare(b1, s1, l1, b2, s2, l2);
                }
                ATypeTag sourceTypeTag = null;
                ATypeTag targetTypeTag = null;
                boolean areTwoTagsEqual = false;
                boolean typePromotionApplied = false;
                boolean leftValueChanged = false;
                if (tag1 != tag2) {
                    if (ATypeHierarchy.canPromote(tag1, tag2)) {
                        sourceTypeTag = tag1;
                        targetTypeTag = tag2;
                        typePromotionApplied = true;
                        leftValueChanged = true;
                    } else if (ATypeHierarchy.canPromote(tag2, tag1)) {
                        sourceTypeTag = tag2;
                        targetTypeTag = tag1;
                        typePromotionApplied = true;
                    }
                    if (typePromotionApplied) {
                        this.castBuffer.reset();
                        this.promoteComputer = ATypeHierarchy.getTypePromoteComputer(sourceTypeTag, targetTypeTag);
                        if (this.promoteComputer == null) throw new HyracksDataException("No appropriate typePromoteComputer exists for " + sourceTypeTag + " to the " + targetTypeTag + " type. Please check the code.");
                        try {
                            if (leftValueChanged) {
                                this.promoteComputer.convertType(b1, s1 + 1, l1 - 1, this.castBuffer.getDataOutput());
                            }
                            this.promoteComputer.convertType(b2, s2 + 1, l2 - 1, this.castBuffer.getDataOutput());
                        }
                        catch (IOException e) {
                            throw new HyracksDataException("ComparatorFactory - failed to promote the type:" + sourceTypeTag + " to the type:" + targetTypeTag);
                        }
                    }
                } else {
                    sourceTypeTag = tag1;
                    targetTypeTag = tag1;
                    areTwoTagsEqual = true;
                }
                if (!areTwoTagsEqual && !typePromotionApplied) {
                    return this.rawComp.compare(b1, s1, l1, b2, s2, l2);
                }
                switch (targetTypeTag) {
                    case UUID: {
                        return this.ascUUIDComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case BOOLEAN: {
                        return this.ascBoolComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case INT8: {
                        return this.ascByteComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case INT16: {
                        if (!typePromotionApplied) {
                            return this.ascShortComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                        }
                        if (!leftValueChanged) return this.ascShortComp.compare(b1, s1 + 1, l1 - 1, this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1);
                        return this.ascShortComp.compare(this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1, b2, s2 + 1, l2 - 1);
                    }
                    case TIME: 
                    case DATE: 
                    case YEARMONTHDURATION: 
                    case INT32: {
                        if (!typePromotionApplied) {
                            return this.ascIntComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                        }
                        if (!leftValueChanged) return this.ascIntComp.compare(b1, s1 + 1, l1 - 1, this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1);
                        return this.ascIntComp.compare(this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1, b2, s2 + 1, l2 - 1);
                    }
                    case DATETIME: 
                    case DAYTIMEDURATION: 
                    case INT64: {
                        if (!typePromotionApplied) {
                            return this.ascLongComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                        }
                        if (!leftValueChanged) return this.ascLongComp.compare(b1, s1 + 1, l1 - 1, this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1);
                        return this.ascLongComp.compare(this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1, b2, s2 + 1, l2 - 1);
                    }
                    case FLOAT: {
                        if (!typePromotionApplied) {
                            return this.ascFloatComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                        }
                        if (!leftValueChanged) return this.ascFloatComp.compare(b1, s1 + 1, l1 - 1, this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1);
                        return this.ascFloatComp.compare(this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1, b2, s2 + 1, l2 - 1);
                    }
                    case DOUBLE: {
                        if (!typePromotionApplied) {
                            return this.ascDoubleComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                        }
                        if (!leftValueChanged) return this.ascDoubleComp.compare(b1, s1 + 1, l1 - 1, this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1);
                        return this.ascDoubleComp.compare(this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1, b2, s2 + 1, l2 - 1);
                    }
                    case STRING: {
                        return this.ascStrComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case RECTANGLE: {
                        return this.ascRectangleComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case CIRCLE: {
                        return this.ascCircleComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case POINT: {
                        return this.ascPointComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case POINT3D: {
                        return this.ascPoint3DComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case LINE: {
                        return this.ascLineComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case POLYGON: {
                        return this.ascPolygonComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case DURATION: {
                        return this.ascDurationComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case INTERVAL: {
                        return this.ascIntervalComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                    case BINARY: {
                        return this.ascByteArrayComp.compare(b1, s1 + 1, l1 - 1, b2, s2 + 1, l2 - 1);
                    }
                }
                return this.rawComp.compare(b1, s1, l1, b2, s2, l2);
            }
        };
    }
}

