/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.common;

import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.dataflow.data.nontagged.serde.AOrderedListSerializerDeserializer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IBinaryTokenizer;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.IToken;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.ITokenFactory;
import org.apache.hyracks.storage.am.lsm.invertedindex.tokenizers.TokenizerInfo;

public class AOrderedListBinaryTokenizer
implements IBinaryTokenizer {
    protected byte[] data;
    protected int start;
    protected int length;
    protected int listLength;
    protected int itemIndex;
    protected final IToken token;

    public AOrderedListBinaryTokenizer(ITokenFactory tokenFactory) {
        this.token = tokenFactory.createToken();
    }

    public IToken getToken() {
        return this.token;
    }

    public boolean hasNext() {
        return this.itemIndex < this.listLength;
    }

    public void next() {
        int itemOffset = -1;
        int length = -1;
        try {
            itemOffset = this.getItemOffset(this.data, this.start, this.itemIndex);
            ATypeTag typeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.data[this.start + 1]);
            length = NonTaggedFormatUtil.getFieldValueLength(this.data, itemOffset, typeTag, false);
            this.token.reset(this.data, itemOffset, itemOffset + length, length, (int)this.data[this.start + 1]);
        }
        catch (AsterixException e) {
            throw new IllegalStateException(e);
        }
        ++this.itemIndex;
    }

    public void reset(byte[] data, int start, int length) {
        this.data = data;
        this.start = start;
        this.length = length;
        this.listLength = this.getNumberOfItems(data, start);
        this.itemIndex = 0;
    }

    protected int getItemOffset(byte[] data, int start, int itemIndex) throws AsterixException {
        return AOrderedListSerializerDeserializer.getItemOffset(data, start, itemIndex);
    }

    protected int getNumberOfItems(byte[] data, int start) {
        return AOrderedListSerializerDeserializer.getNumberOfItems(data, start);
    }

    public short getTokensCount() {
        return (short)this.listLength;
    }

    public TokenizerInfo.TokenizerType getTokenizerType() {
        return TokenizerInfo.TokenizerType.LIST;
    }
}

