/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class PropertiesLoader {
    private static final String MASTER_PLUGIN_FILE = "com/sun/syndication/rome.properties";
    private static final String EXTRA_PLUGIN_FILE = "rome.properties";
    private static PropertiesLoader loader;
    private static Map clMap;
    private Properties[] _properties;

    public static PropertiesLoader getPropertiesLoader() {
        if (loader == null) {
            System.out.println(" CUSTOM PROPERTY LOADING");
            loader = new PropertiesLoader();
        }
        return loader;
    }

    public PropertiesLoader() {
        this.initMasterProperties();
    }

    private void initMasterProperties() {
        Properties p = new Properties();
        p.put("WireFeedParser.classes", "com.sun.syndication.io.impl.RSS090Parser com.sun.syndication.io.impl.RSS091NetscapeParser com.sun.syndication.io.impl.RSS091UserlandParser com.sun.syndication.io.impl.RSS092Parser com.sun.syndication.io.impl.RSS093Parser com.sun.syndication.io.impl.RSS094Parser com.sun.syndication.io.impl.RSS10Parser com.sun.syndication.io.impl.RSS20wNSParser com.sun.syndication.io.impl.RSS20Parser com.sun.syndication.io.impl.Atom10Parser");
        p.put("atom_1.0.feed.ModuleParser.classes", "com.sun.syndication.io.impl.SyModuleParser com.sun.syndication.io.impl.DCModuleParser");
        p.put("atom_1.0.item.ModuleParser.classes", "com.sun.syndication.io.impl.DCModuleParser");
        p.put("atom_0.3.feed.ModuleParser.classes", "com.sun.syndication.io.impl.SyModuleParser com.sun.syndication.io.impl.DCModuleParser");
        p.put("atom_0.3.item.ModuleParser.classes", "com.sun.syndication.io.impl.DCModuleParser");
        p.put("rss_1.0.feed.ModuleParser.classes", "com.sun.syndication.io.impl.SyModuleParser com.sun.syndication.io.impl.DCModuleParser");
        p.put("rss_1.0.item.ModuleParser.classes", "com.sun.syndication.io.impl.DCModuleParser");
        p.put("rss_2.0wNS.feed.ModuleParser.classes", "com.sun.syndication.io.impl.DCModuleParser");
        p.put("rss_2.0wNS.item.ModuleParser.classes", "com.sun.syndication.io.impl.DCModuleParser");
        p.put("rss_2.0.feed.ModuleParser.classes", "com.sun.syndication.io.impl.DCModuleParser");
        p.put("rss_2.0.item.ModuleParser.classes", "com.sun.syndication.io.impl.DCModuleParser");
        p.put("Converter.classes", "com.sun.syndication.feed.synd.impl.ConverterForAtom10 com.sun.syndication.feed.synd.impl.ConverterForAtom03 com.sun.syndication.feed.synd.impl.ConverterForRSS090 com.sun.syndication.feed.synd.impl.ConverterForRSS091Netscape com.sun.syndication.feed.synd.impl.ConverterForRSS091Userland com.sun.syndication.feed.synd.impl.ConverterForRSS092 com.sun.syndication.feed.synd.impl.ConverterForRSS093 com.sun.syndication.feed.synd.impl.ConverterForRSS094 com.sun.syndication.feed.synd.impl.ConverterForRSS10 com.sun.syndication.feed.synd.impl.ConverterForRSS20");
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        propertiesList.add(p);
        this._properties = new Properties[propertiesList.size()];
        propertiesList.toArray(this._properties);
    }

    private PropertiesLoader(String masterFileLocation, String extraFileLocation) throws IOException {
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            InputStream is = classLoader.getResourceAsStream(masterFileLocation);
            Properties p = new Properties();
            p.load(is);
            is.close();
            propertiesList.add(p);
        }
        catch (IOException ioex) {
            IOException ex = new IOException("could not load ROME master plugins file [" + masterFileLocation + "], " + ioex.getMessage());
            ex.setStackTrace(ioex.getStackTrace());
            throw ex;
        }
        Enumeration<URL> urls = classLoader.getResources(extraFileLocation);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            Properties p = new Properties();
            try {
                InputStream is = url.openStream();
                p.load(is);
                is.close();
            }
            catch (IOException ioex) {
                IOException ex = new IOException("could not load ROME extensions plugins file [" + url.toString() + "], " + ioex.getMessage());
                ex.setStackTrace(ioex.getStackTrace());
                throw ex;
            }
            propertiesList.add(p);
        }
        this._properties = new Properties[propertiesList.size()];
        propertiesList.toArray(this._properties);
    }

    private PropertiesLoader(Properties p) {
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        propertiesList.add(p);
        this._properties = new Properties[propertiesList.size()];
        propertiesList.toArray(this._properties);
    }

    public String[] getTokenizedProperty(String key, String separator) {
        ArrayList<String> entriesList = new ArrayList<String>();
        for (int i = 0; i < this._properties.length; ++i) {
            String values = this._properties[i].getProperty(key);
            if (values == null) continue;
            StringTokenizer st = new StringTokenizer(values, separator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                entriesList.add(token);
            }
        }
        String[] entries = new String[entriesList.size()];
        entriesList.toArray(entries);
        return entries;
    }

    public String[] getProperty(String key) {
        ArrayList<String> entriesList = new ArrayList<String>();
        for (int i = 0; i < this._properties.length; ++i) {
            String values = this._properties[i].getProperty(key);
            if (values == null) continue;
            entriesList.add(values);
        }
        String[] entries = new String[entriesList.size()];
        entriesList.toArray(entries);
        return entries;
    }

    static {
        clMap = new WeakHashMap();
    }
}

