/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.impls;

import java.util.ArrayList;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IIndexOperationContext;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallback;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreeLeafFrame;
import org.apache.hyracks.storage.am.rtree.impls.PathList;
import org.apache.hyracks.storage.am.rtree.impls.RTreeCursorInitialState;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSplitKey;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;

public class RTreeOpContext
implements IIndexOperationContext,
IExtraPageBlockHelper {
    private static final int INITIAL_TRAVERSE_LIST_SIZE = 100;
    private static final int INITIAL_HEIGHT = 8;
    public final MultiComparator cmp;
    public final IRTreeInteriorFrame interiorFrame;
    public final IRTreeLeafFrame leafFrame;
    public IndexOperation op;
    public ITreeIndexCursor cursor;
    public RTreeCursorInitialState cursorInitialState;
    public final IPageManager freePageManager;
    public final ITreeIndexMetadataFrame metaFrame;
    public RTreeSplitKey splitKey;
    public ITupleReference tuple;
    public PathList pathList;
    public PathList traverseList;
    public ArrayList<ICachedPage> NSNUpdates;
    public ArrayList<ICachedPage> LSNUpdates;
    public IModificationOperationCallback modificationCallback;

    public RTreeOpContext(IRTreeLeafFrame leafFrame, IRTreeInteriorFrame interiorFrame, IPageManager freePageManager, IBinaryComparatorFactory[] cmpFactories, IModificationOperationCallback modificationCallback) {
        this.cmp = cmpFactories[0] != null ? MultiComparator.create((IBinaryComparatorFactory[])cmpFactories) : null;
        this.interiorFrame = interiorFrame;
        this.leafFrame = leafFrame;
        this.freePageManager = freePageManager;
        this.metaFrame = freePageManager.createMetadataFrame();
        this.modificationCallback = modificationCallback;
        this.pathList = new PathList(8, 8);
        this.NSNUpdates = new ArrayList();
        this.LSNUpdates = new ArrayList();
    }

    public ITupleReference getTuple() {
        return this.tuple;
    }

    public void setTuple(ITupleReference tuple) {
        this.tuple = tuple;
    }

    public void reset() {
        if (this.pathList != null) {
            this.pathList.clear();
        }
        if (this.traverseList != null) {
            this.traverseList.clear();
        }
        this.NSNUpdates.clear();
        this.LSNUpdates.clear();
    }

    public void setOperation(IndexOperation newOp) {
        if (this.op != null && newOp == this.op) {
            return;
        }
        if (this.op != IndexOperation.SEARCH && this.op != IndexOperation.DISKORDERSCAN) {
            if (this.splitKey == null) {
                this.splitKey = new RTreeSplitKey(this.interiorFrame.getTupleWriter().createTupleReference(), this.interiorFrame.getTupleWriter().createTupleReference());
            }
            if (this.traverseList == null) {
                this.traverseList = new PathList(100, 100);
            }
        }
        if (this.cursorInitialState == null) {
            this.cursorInitialState = new RTreeCursorInitialState(this.pathList, 1);
        }
        this.op = newOp;
    }

    public IndexOperation getOperation() {
        return this.op;
    }

    public void setModificationCallback(IModificationOperationCallback modificationCallback) {
        this.modificationCallback = modificationCallback;
    }

    public int getFreeBlock(int size) throws HyracksDataException {
        return this.freePageManager.takeBlock(this.metaFrame, size);
    }

    public void returnFreePageBlock(int blockPageId, int size) throws HyracksDataException {
        this.freePageManager.releaseBlock(this.metaFrame, blockPageId, size);
    }
}

