/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.frames;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.common.api.ISlotManager;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.rtree.api.IRTreeFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreePolicy;
import org.apache.hyracks.storage.am.rtree.frames.RTreeComputationUtils;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSplitKey;
import org.apache.hyracks.storage.am.rtree.impls.Rectangle;
import org.apache.hyracks.storage.am.rtree.impls.UnorderedSlotManager;
import org.apache.hyracks.storage.am.rtree.tuples.RTreeTypeAwareTupleWriter;

public class RTreePolicy
implements IRTreePolicy {
    private Rectangle[] rec;
    private final ITreeIndexTupleWriter tupleWriter;
    private final IPrimitiveValueProvider[] keyValueProviders;
    private ITreeIndexTupleReference cmpFrameTuple;
    private final int totalFreeSpaceOff;

    public RTreePolicy(ITreeIndexTupleWriter tupleWriter, IPrimitiveValueProvider[] keyValueProviders, ITreeIndexTupleReference cmpFrameTuple, int totalFreeSpaceOff) {
        this.tupleWriter = tupleWriter;
        this.keyValueProviders = keyValueProviders;
        this.cmpFrameTuple = cmpFrameTuple;
        this.totalFreeSpaceOff = totalFreeSpaceOff;
        this.rec = new Rectangle[2];
        for (int i = 0; i < 2; ++i) {
            this.rec[i] = new Rectangle(keyValueProviders.length / 2);
        }
    }

    @Override
    public void split(ITreeIndexFrame leftFrame, ByteBuffer buf, ITreeIndexFrame rightFrame, ISlotManager slotManager, ITreeIndexTupleReference frameTuple, ITupleReference tuple, ISplitKey splitKey) throws HyracksDataException {
        int remainingTuplestoBeInsertedInRightFrame;
        RTreeSplitKey rTreeSplitKey = (RTreeSplitKey)splitKey;
        RTreeTypeAwareTupleWriter rTreeTupleWriterLeftFrame = (RTreeTypeAwareTupleWriter)this.tupleWriter;
        RTreeTypeAwareTupleWriter rTreeTupleWriterRightFrame = (RTreeTypeAwareTupleWriter)rightFrame.getTupleWriter();
        RTreeNSMFrame leftRTreeFrame = (RTreeNSMFrame)leftFrame;
        double separation = Double.NEGATIVE_INFINITY;
        int seed1 = 0;
        int seed2 = 0;
        int maxFieldPos = this.keyValueProviders.length / 2;
        for (int i = 0; i < maxFieldPos; ++i) {
            double f;
            int j = maxFieldPos + i;
            frameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, 0);
            double leastLowerValue = this.keyValueProviders[i].getValue(frameTuple.getFieldData(i), frameTuple.getFieldStart(i));
            double greatestUpperValue = this.keyValueProviders[j].getValue(frameTuple.getFieldData(j), frameTuple.getFieldStart(j));
            double leastUpperValue = leastLowerValue;
            double greatestLowerValue = greatestUpperValue;
            int leastUpperIndex = 0;
            int greatestLowerIndex = 0;
            int tupleCount = leftRTreeFrame.getTupleCount();
            for (int k = 1; k < tupleCount; ++k) {
                double higherValue;
                frameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, k);
                double lowerValue = this.keyValueProviders[i].getValue(frameTuple.getFieldData(i), frameTuple.getFieldStart(i));
                if (lowerValue > greatestLowerValue) {
                    greatestLowerIndex = k;
                    this.cmpFrameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, k);
                    greatestLowerValue = this.keyValueProviders[i].getValue(this.cmpFrameTuple.getFieldData(i), this.cmpFrameTuple.getFieldStart(i));
                }
                if ((higherValue = this.keyValueProviders[j].getValue(frameTuple.getFieldData(j), frameTuple.getFieldStart(j))) < leastUpperValue) {
                    leastUpperIndex = k;
                    this.cmpFrameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, k);
                    leastUpperValue = this.keyValueProviders[j].getValue(this.cmpFrameTuple.getFieldData(j), this.cmpFrameTuple.getFieldStart(j));
                }
                leastLowerValue = Math.min(lowerValue, leastLowerValue);
                greatestUpperValue = Math.max(higherValue, greatestUpperValue);
            }
            double width = greatestUpperValue - leastLowerValue;
            if (width <= 0.0) {
                width = 1.0;
            }
            if (!((f = (greatestLowerValue - leastUpperValue) / width) > separation)) continue;
            seed1 = leastUpperIndex;
            seed2 = greatestLowerIndex;
            separation = f;
        }
        if (seed1 == seed2) {
            seed2 = seed1 == 0 ? 1 : --seed2;
        }
        int totalBytes = 0;
        int numOfDeletedTuples = 0;
        frameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, seed1);
        this.rec[0].set((ITupleReference)frameTuple, this.keyValueProviders);
        rightFrame.insert((ITupleReference)frameTuple, -1);
        ((UnorderedSlotManager)slotManager).modifySlot(slotManager.getSlotOff(seed1), -1);
        totalBytes += leftRTreeFrame.getTupleSize((ITupleReference)frameTuple);
        ++numOfDeletedTuples;
        frameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, seed2);
        this.rec[1].set((ITupleReference)frameTuple, this.keyValueProviders);
        for (int k = 0; k < leftRTreeFrame.getTupleCount() && (remainingTuplestoBeInsertedInRightFrame = leftRTreeFrame.getTupleCount() / 2 - rightFrame.getTupleCount()) != 0; ++k) {
            if (k == seed1 || k == seed2) continue;
            frameTuple.resetByTupleIndex((ITreeIndexFrame)leftRTreeFrame, k);
            if (this.rec[0].enlargedArea((ITupleReference)frameTuple, this.keyValueProviders) < this.rec[1].enlargedArea((ITupleReference)frameTuple, this.keyValueProviders) || leftRTreeFrame.getTupleCount() - k <= remainingTuplestoBeInsertedInRightFrame) {
                rightFrame.insert((ITupleReference)frameTuple, -1);
                this.rec[0].enlarge((ITupleReference)frameTuple, this.keyValueProviders);
                ((UnorderedSlotManager)slotManager).modifySlot(slotManager.getSlotOff(k), -1);
                totalBytes += leftRTreeFrame.getTupleSize((ITupleReference)frameTuple);
                ++numOfDeletedTuples;
                continue;
            }
            this.rec[1].enlarge((ITupleReference)frameTuple, this.keyValueProviders);
        }
        ((UnorderedSlotManager)slotManager).deleteEmptySlots();
        buf.putInt(this.totalFreeSpaceOff, buf.getInt(this.totalFreeSpaceOff) + totalBytes + slotManager.getSlotSize() * numOfDeletedTuples);
        rightFrame.compact();
        leftRTreeFrame.compact();
        if (this.rec[0].enlargedArea(tuple, this.keyValueProviders) < this.rec[1].enlargedArea(tuple, this.keyValueProviders)) {
            if (rightFrame.hasSpaceInsert(tuple) == FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE) {
                rightFrame.insert(tuple, -1);
            } else {
                leftRTreeFrame.insert(tuple, -1);
            }
        } else if (leftRTreeFrame.hasSpaceInsert(tuple) == FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE) {
            leftRTreeFrame.insert(tuple, -1);
        } else {
            rightFrame.insert(tuple, -1);
        }
        int tupleOff = slotManager.getTupleOff(slotManager.getSlotEndOff());
        frameTuple.resetByTupleOffset(buf.array(), tupleOff);
        int splitKeySize = this.tupleWriter.bytesRequired((ITupleReference)frameTuple, 0, this.keyValueProviders.length);
        splitKey.initData(splitKeySize);
        leftRTreeFrame.adjustMBR();
        rTreeTupleWriterLeftFrame.writeTupleFields(leftRTreeFrame.getMBRTuples(), 0, rTreeSplitKey.getLeftPageBuffer(), 0);
        rTreeSplitKey.getLeftTuple().resetByTupleOffset(rTreeSplitKey.getLeftPageBuffer().array(), 0);
        ((IRTreeFrame)rightFrame).adjustMBR();
        rTreeTupleWriterRightFrame.writeTupleFields(((RTreeNSMFrame)rightFrame).getMBRTuples(), 0, rTreeSplitKey.getRightPageBuffer(), 0);
        rTreeSplitKey.getRightTuple().resetByTupleOffset(rTreeSplitKey.getRightPageBuffer().array(), 0);
    }

    @Override
    public int findBestChildPosition(ITreeIndexFrame frame, ITupleReference tuple, ITreeIndexTupleReference frameTuple, MultiComparator cmp) throws HyracksDataException {
        this.cmpFrameTuple.setFieldCount(cmp.getKeyFieldCount());
        frameTuple.setFieldCount(cmp.getKeyFieldCount());
        int bestChild = 0;
        double minEnlargedArea = Double.MAX_VALUE;
        for (int i = 0; i < frame.getTupleCount(); ++i) {
            frameTuple.resetByTupleIndex(frame, i);
            double enlargedArea = RTreeComputationUtils.enlargedArea((ITupleReference)frameTuple, tuple, cmp, this.keyValueProviders);
            if (enlargedArea < minEnlargedArea) {
                minEnlargedArea = enlargedArea;
                bestChild = i;
                continue;
            }
            if (enlargedArea != minEnlargedArea) continue;
            double area = RTreeComputationUtils.area((ITupleReference)frameTuple, cmp, this.keyValueProviders);
            frameTuple.resetByTupleIndex(frame, bestChild);
            double minArea = RTreeComputationUtils.area((ITupleReference)frameTuple, cmp, this.keyValueProviders);
            if (!(area < minArea)) continue;
            bestChild = i;
        }
        return bestChild;
    }
}

