/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.frames;

import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriterFactory;
import org.apache.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreeNSMInteriorFrame;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;

public class RTreeNSMInteriorFrameFactory
implements ITreeIndexFrameFactory {
    private static final long serialVersionUID = 1L;
    private final ITreeIndexTupleWriterFactory tupleWriterFactory;
    private final IPrimitiveValueProviderFactory[] keyValueProviderFactories;
    private final RTreePolicyType rtreePolicyType;
    private final boolean isPointMBR;

    public RTreeNSMInteriorFrameFactory(ITreeIndexTupleWriterFactory tupleWriterFactory, IPrimitiveValueProviderFactory[] keyValueProviderFactories, RTreePolicyType rtreePolicyType, boolean isPointMBR) {
        this.tupleWriterFactory = tupleWriterFactory;
        if (keyValueProviderFactories.length % 2 != 0) {
            throw new IllegalArgumentException("The key has different number of dimensions.");
        }
        this.keyValueProviderFactories = keyValueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
        this.isPointMBR = isPointMBR;
    }

    public IRTreeInteriorFrame createFrame() {
        IPrimitiveValueProvider[] keyValueProviders = new IPrimitiveValueProvider[this.keyValueProviderFactories.length];
        for (int i = 0; i < keyValueProviders.length; ++i) {
            keyValueProviders[i] = this.keyValueProviderFactories[i].createPrimitiveValueProvider();
        }
        return new RTreeNSMInteriorFrame(this.tupleWriterFactory.createTupleWriter(), keyValueProviders, this.rtreePolicyType, this.isPointMBR);
    }

    public ITreeIndexTupleWriterFactory getTupleWriterFactory() {
        return this.tupleWriterFactory;
    }
}

