/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.frames;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.common.api.ISlotManager;
import org.apache.hyracks.storage.am.common.api.ISplitKey;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.frames.TreeIndexNSMFrame;
import org.apache.hyracks.storage.am.common.ophelpers.MultiComparator;
import org.apache.hyracks.storage.am.rtree.api.IRTreeFrame;
import org.apache.hyracks.storage.am.rtree.api.IRTreePolicy;
import org.apache.hyracks.storage.am.rtree.frames.RStarTreePolicy;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicy;
import org.apache.hyracks.storage.am.rtree.frames.RTreePolicyType;
import org.apache.hyracks.storage.am.rtree.impls.UnorderedSlotManager;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.IExtraPageBlockHelper;

public abstract class RTreeNSMFrame
extends TreeIndexNSMFrame
implements IRTreeFrame {
    protected static final int PAGE_NSN_OFFSET = 22;
    protected static final int RIGHT_PAGE_OFFSET = 30;
    protected ITreeIndexTupleReference[] mbrTuples;
    protected ITreeIndexTupleReference cmpFrameTuple;
    private static final double DOUBLE_EPSILON = RTreeNSMFrame.computeDoubleEpsilon();
    protected final IPrimitiveValueProvider[] keyValueProviders;
    protected IRTreePolicy rtreePolicy;
    protected final boolean isPointMBR;

    public RTreeNSMFrame(ITreeIndexTupleWriter tupleWriter, IPrimitiveValueProvider[] keyValueProviders, RTreePolicyType rtreePolicyType, boolean isPointMBR) {
        super(tupleWriter, (ISlotManager)new UnorderedSlotManager());
        this.mbrTuples = new ITreeIndexTupleReference[keyValueProviders.length];
        for (int i = 0; i < keyValueProviders.length; ++i) {
            this.mbrTuples[i] = tupleWriter.createTupleReference();
        }
        this.cmpFrameTuple = tupleWriter.createTupleReference();
        this.keyValueProviders = keyValueProviders;
        this.rtreePolicy = rtreePolicyType == RTreePolicyType.RTREE ? new RTreePolicy(tupleWriter, keyValueProviders, this.cmpFrameTuple, 17) : new RStarTreePolicy(tupleWriter, keyValueProviders, this.cmpFrameTuple, 17);
        this.isPointMBR = isPointMBR;
    }

    private static double computeDoubleEpsilon() {
        double doubleEpsilon = 1.0;
        while (1.0 + (doubleEpsilon /= 2.0) / 2.0 != 1.0) {
        }
        return doubleEpsilon;
    }

    public static double doubleEpsilon() {
        return DOUBLE_EPSILON;
    }

    public void initBuffer(byte level) {
        super.initBuffer(level);
        this.buf.putLong(22, 0L);
        this.buf.putInt(30, -1);
    }

    public void setTupleCount(int tupleCount) {
        this.buf.putInt(0, tupleCount);
    }

    @Override
    public void setPageNsn(long pageNsn) {
        this.buf.putLong(22, pageNsn);
    }

    @Override
    public long getPageNsn() {
        return this.buf.getLong(22);
    }

    @Override
    public int getRightPage() {
        return this.buf.getInt(30);
    }

    @Override
    public void setRightPage(int rightPage) {
        this.buf.putInt(30, rightPage);
    }

    public ITreeIndexTupleReference[] getMBRTuples() {
        return this.mbrTuples;
    }

    public void split(ITreeIndexFrame rightFrame, ITupleReference tuple, ISplitKey splitKey, IExtraPageBlockHelper extraPageBlockHelper, IBufferCache bufferCache) throws HyracksDataException {
        this.rtreePolicy.split(this, this.buf, rightFrame, this.slotManager, this.frameTuple, tuple, splitKey);
    }

    public abstract int getTupleSize(ITupleReference var1);

    protected void calculateMBRImpl(ITreeIndexTupleReference[] tuples) {
        int maxFieldPos = this.keyValueProviders.length / 2;
        for (int i = 1; i < this.getTupleCount(); ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            for (int j = 0; j < maxFieldPos; ++j) {
                double valB;
                int k = maxFieldPos + j;
                double valA = this.keyValueProviders[j].getValue(this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j));
                if (valA < (valB = this.keyValueProviders[j].getValue(tuples[j].getFieldData(j), tuples[j].getFieldStart(j)))) {
                    tuples[j].resetByTupleIndex((ITreeIndexFrame)this, i);
                }
                if (!((valA = this.keyValueProviders[k].getValue(this.frameTuple.getFieldData(k), this.frameTuple.getFieldStart(k))) > (valB = this.keyValueProviders[k].getValue(tuples[k].getFieldData(k), tuples[k].getFieldStart(k))))) continue;
                tuples[k].resetByTupleIndex((ITreeIndexFrame)this, i);
            }
        }
    }

    @Override
    public void adjustMBR() {
        for (int i = 0; i < this.mbrTuples.length; ++i) {
            this.mbrTuples[i].setFieldCount(this.getFieldCount());
            this.mbrTuples[i].resetByTupleIndex((ITreeIndexFrame)this, 0);
        }
        this.calculateMBRImpl(this.mbrTuples);
    }

    public abstract int getFieldCount();

    public int getPageHeaderSize() {
        return 34;
    }

    public void setMultiComparator(MultiComparator cmp) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '\n' + ("Tuple Count: " + this.getTupleCount()) + '\n' + ("Free Space offset: " + this.buf.getInt(4)) + '\n' + ("Level: " + this.buf.get(8)) + '\n' + ("LSN: " + this.buf.getLong(9)) + '\n' + ("Total Free Space: " + this.buf.getInt(17)) + '\n' + ("Flag: " + this.buf.get(21)) + '\n' + ("NSN: " + this.buf.getLong(22)) + '\n' + "Right Page:" + this.buf.getInt(30);
    }
}

