/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.ClusterProperties;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.asterix.runtime.utils.ClusterStateManager;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.util.IntSerDeUtils;

public class FeedUtils {
    public static final String FEED_EXTENSION_NAME = "Feed";

    private FeedUtils() {
    }

    private static String prepareDataverseFeedName(String dataverseName, String feedName) {
        return dataverseName + File.separator + feedName;
    }

    public static FileSplit splitsForAdapter(String dataverseName, String feedName, String nodeName, ClusterPartition partition) {
        File relPathFile = new File(FeedUtils.prepareDataverseFeedName(dataverseName, feedName));
        String storageDirName = ClusterProperties.INSTANCE.getStorageDirectoryName();
        String storagePartitionPath = StoragePathUtil.prepareStoragePartitionPath((String)storageDirName, (int)partition.getPartitionId());
        File f = new File(storagePartitionPath + File.separator + relPathFile + File.separator + nodeName);
        return StoragePathUtil.getFileSplitForClusterPartition((ClusterPartition)partition, (String)f.getPath());
    }

    public static FileSplit[] splitsForAdapter(String dataverseName, String feedName, AlgebricksPartitionConstraint partitionConstraints) throws AsterixException {
        if (partitionConstraints.getPartitionConstraintType() == AlgebricksPartitionConstraint.PartitionConstraintType.COUNT) {
            throw new AsterixException("Can't create file splits for adapter with count partitioning constraints");
        }
        String[] locations = ((AlgebricksAbsolutePartitionConstraint)partitionConstraints).getLocations();
        ArrayList<FileSplit> splits = new ArrayList<FileSplit>();
        for (String nd : locations) {
            splits.add(FeedUtils.splitsForAdapter(dataverseName, feedName, nd, ClusterStateManager.INSTANCE.getNodePartitions(nd)[0]));
        }
        return splits.toArray(new FileSplit[0]);
    }

    public static FileReference getAbsoluteFileRef(String relativePath, int ioDeviceId, IIOManager ioManager) {
        return ioManager.getFileReference(ioDeviceId, relativePath);
    }

    public static FeedLogManager getFeedLogManager(IHyracksTaskContext ctx, int partition, FileSplit[] feedLogFileSplits) throws HyracksDataException {
        return new FeedLogManager(FeedUtils.getAbsoluteFileRef(feedLogFileSplits[partition].getPath(), 0, ctx.getIOManager()).getFile());
    }

    public static FeedLogManager getFeedLogManager(IHyracksTaskContext ctx, FileSplit feedLogFileSplit) throws HyracksDataException {
        return new FeedLogManager(FeedUtils.getAbsoluteFileRef(feedLogFileSplit.getPath(), 0, ctx.getIOManager()).getFile());
    }

    public static void processFeedMessage(ByteBuffer input, VSizeFrame message, FrameTupleAccessor fta) throws HyracksDataException {
        fta.reset(input);
        int tc = fta.getTupleCount() - 1;
        int offset = fta.getTupleStartOffset(tc);
        int len = fta.getTupleLength(tc);
        int newSize = FrameHelper.calcAlignedFrameSizeToStore((int)1, (int)len, (int)message.getMinSize());
        message.reset();
        message.ensureFrameSize(newSize);
        message.getBuffer().clear();
        message.getBuffer().put(input.array(), offset, len);
        message.getBuffer().flip();
        IntSerDeUtils.putInt((byte[])input.array(), (int)FrameHelper.getTupleCountOffset((int)input.capacity()), (int)tc);
    }

    public static String getFeedMetaTypeName(Map<String, String> configuration) {
        return configuration.get("meta-type-name");
    }

    public static enum Mode {
        PROCESS,
        SPILL,
        DISCARD;

    }

    public static enum FeedRuntimeType {
        INTAKE,
        COLLECT,
        COMPUTE_COLLECT,
        COMPUTE,
        STORE,
        OTHER,
        ETS,
        JOIN;

    }

    public static enum JobType {
        INTAKE,
        FEED_CONNECT;

    }
}

