/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.stream.EmptyLineSeparatedRecordReader;
import org.apache.asterix.external.input.record.reader.stream.LineRecordReader;
import org.apache.asterix.external.input.record.reader.stream.QuotedLineRecordReader;
import org.apache.asterix.external.input.record.reader.stream.SemiStructuredRecordReader;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class StreamRecordReaderProvider {
    public static Format getReaderFormat(Map<String, String> configuration) throws AsterixException {
        String format = configuration.get("format");
        if (format != null) {
            switch (format) {
                case "adm": 
                case "json": 
                case "semi-structured": {
                    return Format.SEMISTRUCTURED;
                }
                case "line-separated": {
                    return Format.LINE_SEPARATED;
                }
                case "delimited-text": 
                case "csv": {
                    return Format.CSV;
                }
            }
            throw new AsterixException("Unknown format: " + format);
        }
        throw new AsterixException("Unspecified parameter: format");
    }

    public static StreamRecordReader createRecordReader(Format format, AsterixInputStream inputStream, Map<String, String> configuration) throws HyracksDataException {
        switch (format) {
            case CSV: {
                String quoteString = configuration.get("quote");
                boolean hasHeader = ExternalDataUtils.hasHeader(configuration);
                if (quoteString != null) {
                    return new QuotedLineRecordReader(hasHeader, inputStream, quoteString);
                }
                return new LineRecordReader(hasHeader, inputStream);
            }
            case LINE_SEPARATED: {
                return new EmptyLineSeparatedRecordReader(inputStream);
            }
            case SEMISTRUCTURED: {
                return new SemiStructuredRecordReader(inputStream, configuration.get("record-start"), configuration.get("record-end"));
            }
        }
        throw new RuntimeDataException(3026, new Serializable[]{format});
    }

    public static enum Format {
        SEMISTRUCTURED,
        CSV,
        LINE_SEPARATED;

    }
}

