/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.provider;

import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.ILookupReaderFactory;
import org.apache.asterix.external.input.record.reader.hdfs.HDFSLookupReaderFactory;
import org.apache.asterix.external.util.HDFSUtils;

public class LookupReaderFactoryProvider {
    public static ILookupReaderFactory getLookupReaderFactory(Map<String, String> configuration) throws AsterixException {
        String inputFormat = HDFSUtils.getInputFormatClassName(configuration);
        if (inputFormat.equals("org.apache.hadoop.mapred.TextInputFormat") || inputFormat.equals("org.apache.hadoop.mapred.SequenceFileInputFormat") || inputFormat.equals("org.apache.asterix.hivecompat.io.RCFileInputFormat")) {
            HDFSLookupReaderFactory readerFactory = new HDFSLookupReaderFactory();
            readerFactory.configure(configuration);
            return readerFactory;
        }
        throw new AsterixException("Unrecognized external format");
    }
}

