/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import java.io.Serializable;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordDataParserFactory;
import org.apache.asterix.external.input.record.RecordWithMetadataAndPK;
import org.apache.asterix.external.input.record.converter.IRecordConverterFactory;
import org.apache.asterix.external.parser.RecordWithMetadataParser;
import org.apache.asterix.external.provider.ParserFactoryProvider;
import org.apache.asterix.external.provider.RecordConverterFactoryProvider;
import org.apache.asterix.external.util.ExternalDataCompatibilityUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RecordWithMetadataParserFactory<I, O>
implements IRecordDataParserFactory<I> {
    private static final long serialVersionUID = 1L;
    private static String[] formats = new String[]{"record-with-metadata"};
    private ARecordType metaType;
    private ARecordType recordType;
    private IRecordDataParserFactory<O> recordParserFactory;
    private IRecordConverterFactory<I, RecordWithMetadataAndPK<O>> converterFactory;

    @Override
    public void configure(Map<String, String> configuration) throws AsterixException {
        String recordFormat = configuration.get("record-format");
        if (recordFormat == null) {
            throw new AsterixException(3027, new Serializable[]{"format"});
        }
        String format = configuration.get("format");
        if (format == null) {
            throw new AsterixException(3027, new Serializable[]{"format"});
        }
        this.recordParserFactory = (IRecordDataParserFactory)ParserFactoryProvider.getDataParserFactory(recordFormat);
        this.recordParserFactory.setRecordType(this.recordType);
        this.recordParserFactory.setMetaType(this.metaType);
        this.recordParserFactory.configure(configuration);
        this.converterFactory = RecordConverterFactoryProvider.getConverterFactory(format, recordFormat);
        this.converterFactory.setRecordType(this.recordType);
        this.converterFactory.setMetaType(this.metaType);
        this.converterFactory.configure(configuration);
        ExternalDataCompatibilityUtils.validateCompatibility(this.recordParserFactory, this.converterFactory);
    }

    @Override
    public void setRecordType(ARecordType recordType) {
        this.recordType = recordType;
    }

    @Override
    public void setMetaType(ARecordType metaType) {
        this.metaType = metaType;
    }

    @Override
    public String[] getFormats() {
        return formats;
    }

    @Override
    public Class<?> getRecordClass() {
        return this.converterFactory.getInputClass();
    }

    @Override
    public IRecordDataParser<I> createRecordParser(IHyracksTaskContext ctx) throws HyracksDataException {
        IRecordDataParser<O> recordParser = this.recordParserFactory.createRecordParser(ctx);
        return new RecordWithMetadataParser<I, O>(this.metaType, recordParser, this.converterFactory.createConverter());
    }
}

