/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser.factory;

import java.util.Map;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordDataParserFactory;
import org.apache.asterix.external.parser.HiveRecordParser;
import org.apache.asterix.external.util.HDFSUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hadoop.io.Writable;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class HiveDataParserFactory
implements IRecordDataParserFactory<Writable> {
    private static final long serialVersionUID = 1L;
    private static String[] formats = new String[]{"hive", "hive-parser"};
    private Map<String, String> configuration;
    private ARecordType recordType;
    private String hiveSerdeClassName;

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public void configure(Map<String, String> configuration) {
        this.configuration = configuration;
        this.hiveSerdeClassName = configuration.get("hive-serde");
        if (this.hiveSerdeClassName == null) {
            throw new IllegalArgumentException("no hive serde provided for hive deserialized records");
        }
    }

    @Override
    public void setRecordType(ARecordType recordType) {
        this.recordType = recordType;
    }

    @Override
    public IRecordDataParser<Writable> createRecordParser(IHyracksTaskContext ctx) throws HyracksDataException {
        return new HiveRecordParser(this.recordType, HDFSUtils.configureHDFSJobConf(this.configuration), this.hiveSerdeClassName);
    }

    @Override
    public Class<? extends Writable> getRecordClass() {
        return Writable.class;
    }

    @Override
    public void setMetaType(ARecordType metaType) {
    }

    @Override
    public String[] getFormats() {
        return formats;
    }
}

