/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.external.api.IDataParser;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordConverter;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordWithMetadataParser;
import org.apache.asterix.external.input.record.RecordWithMetadataAndPK;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;

public class RecordWithMetadataParser<T, O>
implements IRecordWithMetadataParser<T> {
    private final IRecordConverter<T, RecordWithMetadataAndPK<O>> converter;
    private RecordWithMetadataAndPK<O> rwm;
    private final IRecordDataParser<O> recordParser;
    private final ARecordType metaType;
    private final RecordBuilder metaBuilder;
    private final ArrayBackedValueStorage[] metaFieldsNamesBuffers;
    private final int numberOfMetaFields;
    private final ISerializerDeserializer<AString> stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);

    public RecordWithMetadataParser(ARecordType metaType, IRecordDataParser<O> valueParser, IRecordConverter<T, RecordWithMetadataAndPK<O>> converter) throws HyracksDataException {
        this.recordParser = valueParser;
        this.converter = converter;
        this.metaType = metaType;
        this.numberOfMetaFields = metaType.getFieldNames().length;
        this.metaBuilder = new RecordBuilder();
        this.metaBuilder.reset(metaType);
        this.metaBuilder.init();
        this.metaFieldsNamesBuffers = new ArrayBackedValueStorage[this.numberOfMetaFields];
        AMutableString str = new AMutableString(null);
        for (int i = 0; i < this.numberOfMetaFields; ++i) {
            String name = metaType.getFieldNames()[i];
            this.metaFieldsNamesBuffers[i] = new ArrayBackedValueStorage();
            str.setValue(name);
            IDataParser.toBytes(str, this.metaFieldsNamesBuffers[i], this.stringSerde);
        }
    }

    @Override
    public void parse(IRawRecord<? extends T> record, DataOutput out) throws HyracksDataException {
        try {
            this.rwm = this.converter.convert(record);
            if (this.rwm.getRecord().size() == 0) {
                out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
            } else {
                this.recordParser.parse(this.rwm.getRecord(), out);
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public void parseMeta(DataOutput out) throws HyracksDataException {
        try {
            if (this.rwm.getRecord().size() == 0) {
                out.writeByte(ATypeTag.SERIALIZED_MISSING_TYPE_TAG);
            } else {
                this.metaBuilder.reset(this.metaType);
                this.metaBuilder.init();
                for (int i = 0; i < this.numberOfMetaFields; ++i) {
                    this.metaBuilder.addField(i, (IValueReference)this.rwm.getMetadata(i));
                }
                this.metaBuilder.write(out, true);
            }
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public void appendLastParsedPrimaryKeyToTuple(ArrayTupleBuilder tb) throws HyracksDataException {
        this.rwm.appendPrimaryKeyToTuple(tb);
    }
}

