/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.parser;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.BitSet;
import java.util.List;
import org.apache.asterix.builders.AbvsBuilderFactory;
import org.apache.asterix.builders.IARecordBuilder;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.ListBuilderFactory;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.RecordBuilderFactory;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.dataflow.data.nontagged.serde.APolygonSerializerDeserializer;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.parser.AbstractDataParser;
import org.apache.asterix.om.base.ABoolean;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.om.types.hierachy.ITypeConvertComputer;
import org.apache.asterix.om.util.container.IObjectFactory;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.util.container.ListObjectPool;
import org.apache.asterix.runtime.operators.file.adm.AdmLexer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IMutableValueStorage;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ADMDataParser
extends AbstractDataParser
implements IStreamDataParser,
IRecordDataParser<char[]> {
    private AdmLexer admLexer;
    private final ARecordType recordType;
    private final ArrayBackedValueStorage castBuffer = new ArrayBackedValueStorage();
    private final IObjectPool<IARecordBuilder, ATypeTag> recordBuilderPool = new ListObjectPool((IObjectFactory)new RecordBuilderFactory());
    private final IObjectPool<IAsterixListBuilder, ATypeTag> listBuilderPool = new ListObjectPool((IObjectFactory)new ListBuilderFactory());
    private final IObjectPool<IMutableValueStorage, ATypeTag> abvsBuilderPool = new ListObjectPool((IObjectFactory)new AbvsBuilderFactory());
    private final String mismatchErrorMessage = "Mismatch Type, expecting a value of type ";
    private final String mismatchErrorMessage2 = " got a value of type ";

    public ADMDataParser(ARecordType recordType, boolean isStream) {
        this(null, recordType, isStream);
    }

    public ADMDataParser(String filename, ARecordType recordType, boolean isStream) {
        this.filename = filename;
        this.recordType = recordType;
        if (!isStream) {
            this.admLexer = new AdmLexer();
        }
    }

    @Override
    public boolean parse(DataOutput out) throws HyracksDataException {
        try {
            this.resetPools();
            return this.parseAdmInstance((IAType)this.recordType, out);
        }
        catch (ParseException e) {
            e.setLocation(this.filename, this.admLexer.getLine(), this.admLexer.getColumn());
            throw e;
        }
        catch (IOException e) {
            throw new ParseException(e, this.filename, this.admLexer.getLine(), this.admLexer.getColumn());
        }
    }

    @Override
    public void parse(IRawRecord<? extends char[]> record, DataOutput out) throws HyracksDataException {
        try {
            this.resetPools();
            this.admLexer.setBuffer(record.get());
            this.parseAdmInstance((IAType)this.recordType, out);
        }
        catch (ParseException e) {
            e.setLocation(this.filename, this.admLexer.getLine(), this.admLexer.getColumn());
            throw e;
        }
        catch (IOException e) {
            throw new ParseException(e, this.filename, this.admLexer.getLine(), this.admLexer.getColumn());
        }
    }

    @Override
    public void setInputStream(InputStream in) throws IOException {
        this.admLexer = new AdmLexer(new InputStreamReader(in));
    }

    protected boolean parseAdmInstance(IAType objectType, DataOutput out) throws IOException {
        int token = this.admLexer.next();
        if (token == 0) {
            return false;
        }
        this.admFromLexerStream(token, objectType, out);
        return true;
    }

    private void admFromLexerStream(int token, IAType objectType, DataOutput out) throws IOException {
        switch (token) {
            case 26: {
                if (this.checkType(ATypeTag.NULL, objectType)) {
                    this.nullSerde.serialize((Object)ANull.NULL, out);
                    break;
                }
                throw new ParseException(3053, new Serializable[]{""});
            }
            case 27: {
                if (this.checkType(ATypeTag.BOOLEAN, objectType)) {
                    this.booleanSerde.serialize((Object)ABoolean.TRUE, out);
                    break;
                }
                throw new ParseException(3054, new Serializable[]{objectType.getTypeName()});
            }
            case 2: {
                this.parseConstructor(ATypeTag.BOOLEAN, objectType, out);
                break;
            }
            case 28: {
                if (this.checkType(ATypeTag.BOOLEAN, objectType)) {
                    this.booleanSerde.serialize((Object)ABoolean.FALSE, out);
                    break;
                }
                throw new ParseException(3054, new Serializable[]{objectType.getTypeName()});
            }
            case 45: {
                this.parseToNumericTarget(ATypeTag.DOUBLE, objectType, out);
                break;
            }
            case 8: {
                this.parseConstructor(ATypeTag.DOUBLE, objectType, out);
                break;
            }
            case 46: {
                this.parseToNumericTarget(ATypeTag.FLOAT, objectType, out);
                break;
            }
            case 7: {
                this.parseConstructor(ATypeTag.FLOAT, objectType, out);
                break;
            }
            case 40: {
                this.parseAndCastNumeric(ATypeTag.INT8, objectType, out);
                break;
            }
            case 3: {
                this.parseConstructor(ATypeTag.INT8, objectType, out);
                break;
            }
            case 41: {
                this.parseAndCastNumeric(ATypeTag.INT16, objectType, out);
                break;
            }
            case 4: {
                this.parseConstructor(ATypeTag.INT16, objectType, out);
                break;
            }
            case 39: {
                this.parseAndCastNumeric(ATypeTag.INT64, objectType, out);
                break;
            }
            case 42: {
                this.parseAndCastNumeric(ATypeTag.INT32, objectType, out);
                break;
            }
            case 5: {
                this.parseConstructor(ATypeTag.INT32, objectType, out);
                break;
            }
            case 43: {
                this.parseAndCastNumeric(ATypeTag.INT64, objectType, out);
                break;
            }
            case 6: {
                this.parseConstructor(ATypeTag.INT64, objectType, out);
                break;
            }
            case 38: {
                if (this.checkType(ATypeTag.STRING, objectType)) {
                    String tokenImage = this.admLexer.getLastTokenImage().substring(1, this.admLexer.getLastTokenImage().length() - 1);
                    this.aString.setValue(this.admLexer.containsEscapes() ? this.replaceEscapes(tokenImage) : tokenImage);
                    this.stringSerde.serialize((Object)this.aString, out);
                    break;
                }
                if (this.checkType(ATypeTag.UUID, objectType)) {
                    String tokenImage = this.admLexer.getLastTokenImage().substring(1, this.admLexer.getLastTokenImage().length() - 1);
                    this.aUUID.parseUUIDString(tokenImage);
                    this.uuidSerde.serialize((Object)this.aUUID, out);
                    break;
                }
                throw new ParseException(3054, new Serializable[]{objectType.getTypeName()});
            }
            case 12: {
                this.parseConstructor(ATypeTag.STRING, objectType, out);
                break;
            }
            case 13: 
            case 14: {
                if (this.checkType(ATypeTag.BINARY, objectType) && this.admLexer.next() == 29 && this.admLexer.next() == 38) {
                    this.parseToBinaryTarget(token, this.admLexer.getLastTokenImage(), out);
                    if (this.admLexer.next() == 30) break;
                }
                throw new ParseException(3054, new Serializable[]{objectType.getTypeName()});
            }
            case 9: {
                this.parseConstructor(ATypeTag.DATE, objectType, out);
                break;
            }
            case 21: {
                this.parseConstructor(ATypeTag.TIME, objectType, out);
                break;
            }
            case 10: {
                this.parseConstructor(ATypeTag.DATETIME, objectType, out);
                break;
            }
            case 22: {
                if (this.checkType(ATypeTag.INTERVAL, objectType)) {
                    objectType = this.getComplexType(objectType, ATypeTag.INTERVAL);
                    this.parseInterval(ATypeTag.INTERVAL, objectType, out);
                    break;
                }
                throw new ParseException(3054, new Serializable[]{objectType.getTypeName()});
            }
            case 11: {
                this.parseConstructor(ATypeTag.DURATION, objectType, out);
                break;
            }
            case 23: {
                this.parseConstructor(ATypeTag.YEARMONTHDURATION, objectType, out);
                break;
            }
            case 24: {
                this.parseConstructor(ATypeTag.DAYTIMEDURATION, objectType, out);
                break;
            }
            case 15: {
                this.parseConstructor(ATypeTag.POINT, objectType, out);
                break;
            }
            case 16: {
                this.parseConstructor(ATypeTag.POINT3D, objectType, out);
                break;
            }
            case 20: {
                this.parseConstructor(ATypeTag.CIRCLE, objectType, out);
                break;
            }
            case 19: {
                this.parseConstructor(ATypeTag.RECTANGLE, objectType, out);
                break;
            }
            case 17: {
                this.parseConstructor(ATypeTag.LINE, objectType, out);
                break;
            }
            case 18: {
                this.parseConstructor(ATypeTag.POLYGON, objectType, out);
                break;
            }
            case 37: {
                if (this.checkType(ATypeTag.UNORDEREDLIST, objectType)) {
                    objectType = this.getComplexType(objectType, ATypeTag.UNORDEREDLIST);
                    this.parseUnorderedList((AUnorderedListType)objectType, out);
                    break;
                }
                throw new ParseException(3054, new Serializable[]{objectType.getTypeName()});
            }
            case 35: {
                if (this.checkType(ATypeTag.ORDEREDLIST, objectType)) {
                    objectType = this.getComplexType(objectType, ATypeTag.ORDEREDLIST);
                    this.parseOrderedList((AOrderedListType)objectType, out);
                    break;
                }
                throw new ParseException(3054, new Serializable[]{objectType.getTypeName()});
            }
            case 31: {
                if (this.checkType(ATypeTag.RECORD, objectType)) {
                    objectType = this.getComplexType(objectType, ATypeTag.RECORD);
                    this.parseRecord((ARecordType)objectType, out);
                    break;
                }
                throw new ParseException(3054, new Serializable[]{objectType.getTypeName()});
            }
            case 25: {
                this.parseConstructor(ATypeTag.UUID, objectType, out);
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new ParseException(3055, new Serializable[]{AdmLexer.tokenKindToString(token)});
            }
        }
    }

    private String replaceEscapes(String tokenImage) throws ParseException {
        int readpos;
        char[] chars = tokenImage.toCharArray();
        int len = chars.length;
        int writepos = 0;
        int movemarker = 0;
        for (readpos = 0; readpos < len; ++readpos) {
            if (chars[readpos] == '\\') {
                ADMDataParser.moveChars(chars, movemarker, readpos, readpos - writepos);
                switch (chars[readpos + 1]) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        chars[writepos] = chars[readpos + 1];
                        break;
                    }
                    case 'b': {
                        chars[writepos] = 8;
                        break;
                    }
                    case 'f': {
                        chars[writepos] = 12;
                        break;
                    }
                    case 'n': {
                        chars[writepos] = 10;
                        break;
                    }
                    case 'r': {
                        chars[writepos] = 13;
                        break;
                    }
                    case 't': {
                        chars[writepos] = 9;
                        break;
                    }
                    case 'u': {
                        chars[writepos] = (char)Integer.parseInt(new String(chars, readpos + 2, 4), 16);
                        readpos += 4;
                        break;
                    }
                    default: {
                        throw new ParseException(3056, Character.valueOf(chars[readpos + 1]));
                    }
                }
                movemarker = ++readpos + 1;
            }
            ++writepos;
        }
        ADMDataParser.moveChars(chars, movemarker, len, readpos - writepos);
        return new String(chars, 0, len - (readpos - writepos));
    }

    private static void moveChars(char[] chars, int start, int end, int offset) {
        if (offset == 0) {
            return;
        }
        for (int i = start; i < end; ++i) {
            chars[i - offset] = chars[i];
        }
    }

    private IAType getComplexType(IAType aObjectType, ATypeTag tag) {
        AUnionType unionType;
        IAType type;
        if (aObjectType == null) {
            return null;
        }
        if (aObjectType.getTypeTag() == tag) {
            return aObjectType;
        }
        if (aObjectType.getTypeTag() == ATypeTag.UNION && (type = (unionType = (AUnionType)aObjectType).getActualType()).getTypeTag() == tag) {
            return type;
        }
        return null;
    }

    private ATypeTag getTargetTypeTag(ATypeTag expectedTypeTag, IAType aObjectType) throws HyracksDataException {
        if (aObjectType == null) {
            return expectedTypeTag;
        }
        if (aObjectType.getTypeTag() != ATypeTag.UNION) {
            ATypeTag typeTag = aObjectType.getTypeTag();
            if (ATypeHierarchy.canPromote((ATypeTag)expectedTypeTag, (ATypeTag)typeTag) || ATypeHierarchy.canDemote((ATypeTag)expectedTypeTag, (ATypeTag)typeTag)) {
                return typeTag;
            }
            return null;
        }
        List unionList = ((AUnionType)aObjectType).getUnionList();
        for (IAType t : unionList) {
            ATypeTag typeTag = t.getTypeTag();
            if (!ATypeHierarchy.canPromote((ATypeTag)expectedTypeTag, (ATypeTag)typeTag) && !ATypeHierarchy.canDemote((ATypeTag)expectedTypeTag, (ATypeTag)typeTag)) continue;
            return typeTag;
        }
        return null;
    }

    private boolean checkType(ATypeTag expectedTypeTag, IAType aObjectType) throws IOException {
        return this.getTargetTypeTag(expectedTypeTag, aObjectType) != null;
    }

    private void parseRecord(ARecordType recType, DataOutput out) throws IOException {
        int nullableFieldId;
        ArrayBackedValueStorage fieldValueBuffer = this.getTempBuffer();
        ArrayBackedValueStorage fieldNameBuffer = this.getTempBuffer();
        IARecordBuilder recBuilder = this.getRecordBuilder();
        BitSet nulls = null;
        if (recType != null) {
            nulls = new BitSet(recType.getFieldNames().length);
            recBuilder.reset(recType);
        } else {
            recBuilder.reset(null);
        }
        recBuilder.init();
        boolean inRecord = true;
        boolean expectingRecordField = false;
        boolean first = true;
        Boolean openRecordField = false;
        int fieldId = 0;
        IAType fieldType = null;
        do {
            int token = this.admLexer.next();
            switch (token) {
                case 32: {
                    if (expectingRecordField) {
                        throw new ParseException(3057, new Serializable[0]);
                    }
                    inRecord = false;
                    break;
                }
                case 38: {
                    fieldNameBuffer.reset();
                    fieldValueBuffer.reset();
                    expectingRecordField = false;
                    if (recType != null) {
                        String fldName = this.admLexer.getLastTokenImage().substring(1, this.admLexer.getLastTokenImage().length() - 1);
                        fieldId = recBuilder.getFieldId(fldName);
                        if (fieldId < 0 && !recType.isOpen()) {
                            throw new ParseException(3058, new Serializable[]{fldName});
                        }
                        if (fieldId < 0 && recType.isOpen()) {
                            this.aStringFieldName.setValue(this.admLexer.getLastTokenImage().substring(1, this.admLexer.getLastTokenImage().length() - 1));
                            this.stringSerde.serialize((Object)this.aStringFieldName, fieldNameBuffer.getDataOutput());
                            openRecordField = true;
                            fieldType = null;
                        } else {
                            nulls.set(fieldId);
                            fieldType = recType.getFieldTypes()[fieldId];
                            openRecordField = false;
                        }
                    } else {
                        this.aStringFieldName.setValue(this.admLexer.getLastTokenImage().substring(1, this.admLexer.getLastTokenImage().length() - 1));
                        this.stringSerde.serialize((Object)this.aStringFieldName, fieldNameBuffer.getDataOutput());
                        openRecordField = true;
                        fieldType = null;
                    }
                    token = this.admLexer.next();
                    if (token != 34) {
                        throw new ParseException(3059, new Serializable[]{AdmLexer.tokenKindToString(token)});
                    }
                    token = this.admLexer.next();
                    this.admFromLexerStream(token, fieldType, fieldValueBuffer.getDataOutput());
                    if (openRecordField.booleanValue()) {
                        recBuilder.addField((IValueReference)fieldNameBuffer, (IValueReference)fieldValueBuffer);
                        break;
                    }
                    recBuilder.addField(fieldId, (IValueReference)fieldValueBuffer);
                    break;
                }
                case 33: {
                    if (first) {
                        throw new ParseException(3060, new Serializable[]{"before any"});
                    }
                    if (expectingRecordField) {
                        throw new ParseException(3060, new Serializable[]{"expecting a"});
                    }
                    expectingRecordField = true;
                    break;
                }
                default: {
                    throw new ParseException(3055, new Serializable[]{AdmLexer.tokenKindToString(token)});
                }
            }
            first = false;
        } while (inRecord);
        if (recType != null && (nullableFieldId = this.checkOptionalConstraints(recType, nulls)) != -1) {
            throw new ParseException(3053, new Serializable[]{recType.getFieldNames()[nullableFieldId]});
        }
        recBuilder.write(out, true);
    }

    private int checkOptionalConstraints(ARecordType recType, BitSet nulls) {
        for (int i = 0; i < recType.getFieldTypes().length; ++i) {
            AUnionType unionType;
            if (nulls.get(i)) continue;
            IAType type = recType.getFieldTypes()[i];
            if (type.getTypeTag() != ATypeTag.NULL && type.getTypeTag() != ATypeTag.UNION) {
                return i;
            }
            if (type.getTypeTag() != ATypeTag.UNION || (unionType = (AUnionType)type).isUnknownableType()) continue;
            return i;
        }
        return -1;
    }

    private void parseInterval(ATypeTag typeTag, IAType objectType, DataOutput out) throws IOException {
        long start = 0L;
        long end = 0L;
        byte tag = 0;
        int token = this.admLexer.next();
        if (token == 29) {
            ATypeTag intervalType;
            token = this.admLexer.next();
            switch (token) {
                case 9: {
                    intervalType = ATypeTag.DATE;
                    break;
                }
                case 21: {
                    intervalType = ATypeTag.TIME;
                    break;
                }
                case 10: {
                    intervalType = ATypeTag.DATETIME;
                    break;
                }
                default: {
                    throw new ParseException(3061, new Serializable[]{AdmLexer.tokenKindToString(token)});
                }
            }
            start = this.parseIntervalArgument(intervalType);
            end = this.parseIntervalSecondArgument(token, intervalType);
            tag = intervalType.serialize();
        }
        if ((token = this.admLexer.next()) == 30) {
            try {
                this.aInterval.setValue(start, end, tag);
            }
            catch (HyracksDataException e) {
                throw new ParseException(e);
            }
        } else {
            throw new ParseException(3062, new Serializable[0]);
        }
        intervalSerde.serialize((Object)this.aInterval, out);
    }

    private long parseIntervalSecondArgument(int startToken, ATypeTag parseType) throws IOException {
        int token = this.admLexer.next();
        if (token == 33) {
            token = this.admLexer.next();
            if (token == startToken) {
                return this.parseIntervalArgument(parseType);
            }
            throw new ParseException(3063, new Serializable[]{AdmLexer.tokenKindToString(startToken), AdmLexer.tokenKindToString(token)});
        }
        throw new ParseException(3064, new Serializable[0]);
    }

    private long parseIntervalArgument(ATypeTag tag) throws IOException {
        int token = this.admLexer.next();
        if (token == 29 && (token = this.admLexer.next()) == 38) {
            long chrononTimeInMs = 0L;
            String arg = this.admLexer.getLastTokenImage();
            switch (tag) {
                case DATE: {
                    chrononTimeInMs += this.parseDatePart(arg, 0, arg.length() - 1) / 86400000L;
                    break;
                }
                case TIME: {
                    chrononTimeInMs += (long)this.parseTimePart(arg, 0, arg.length() - 1);
                    break;
                }
                case DATETIME: {
                    int timeSeperatorOffsetInDatetimeString = arg.indexOf(84);
                    if (timeSeperatorOffsetInDatetimeString < 0) {
                        throw new ParseException(3065, new Serializable[0]);
                    }
                    chrononTimeInMs += this.parseDatePart(arg, 0, timeSeperatorOffsetInDatetimeString - 1);
                    chrononTimeInMs += (long)this.parseTimePart(arg, timeSeperatorOffsetInDatetimeString + 1, arg.length() - 1);
                    break;
                }
                default: {
                    throw new ParseException(3066, new Serializable[0]);
                }
            }
            token = this.admLexer.next();
            if (token == 30) {
                return chrononTimeInMs;
            }
        }
        throw new ParseException(3067, new Serializable[0]);
    }

    private void parseOrderedList(AOrderedListType oltype, DataOutput out) throws IOException {
        ArrayBackedValueStorage itemBuffer = this.getTempBuffer();
        OrderedListBuilder orderedListBuilder = (OrderedListBuilder)this.getOrderedListBuilder();
        IAType itemType = null;
        if (oltype != null) {
            itemType = oltype.getItemType();
        }
        orderedListBuilder.reset((AbstractCollectionType)oltype);
        boolean inList = true;
        boolean expectingListItem = false;
        boolean first = true;
        do {
            int token;
            if ((token = this.admLexer.next()) == 36) {
                if (expectingListItem) {
                    throw new ParseException(3068, new Serializable[0]);
                }
                inList = false;
            } else if (token == 33) {
                if (first) {
                    throw new ParseException(3069, new Serializable[0]);
                }
                if (expectingListItem) {
                    throw new ParseException(3070, new Serializable[0]);
                }
                expectingListItem = true;
            } else {
                expectingListItem = false;
                itemBuffer.reset();
                this.admFromLexerStream(token, itemType, itemBuffer.getDataOutput());
                orderedListBuilder.addItem((IValueReference)itemBuffer);
            }
            first = false;
        } while (inList);
        orderedListBuilder.write(out, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseUnorderedList(AUnorderedListType uoltype, DataOutput out) throws IOException {
        ArrayBackedValueStorage itemBuffer = this.getTempBuffer();
        UnorderedListBuilder unorderedListBuilder = (UnorderedListBuilder)this.getUnorderedListBuilder();
        IAType itemType = null;
        if (uoltype != null) {
            itemType = uoltype.getItemType();
        }
        unorderedListBuilder.reset((AbstractCollectionType)uoltype);
        boolean inList = true;
        boolean expectingListItem = false;
        boolean first = true;
        do {
            int token;
            if ((token = this.admLexer.next()) == 32) {
                if (this.admLexer.next() != 32) throw new ParseException(3071, new Serializable[0]);
                if (expectingListItem) {
                    throw new ParseException(3068, new Serializable[0]);
                }
                inList = false;
            } else if (token == 33) {
                if (first) {
                    throw new ParseException(3069, new Serializable[0]);
                }
                if (expectingListItem) {
                    throw new ParseException(3070, new Serializable[0]);
                }
                expectingListItem = true;
            } else {
                expectingListItem = false;
                itemBuffer.reset();
                this.admFromLexerStream(token, itemType, itemBuffer.getDataOutput());
                unorderedListBuilder.addItem((IValueReference)itemBuffer);
            }
            first = false;
        } while (inList);
        unorderedListBuilder.write(out, true);
    }

    private IARecordBuilder getRecordBuilder() {
        return (IARecordBuilder)this.recordBuilderPool.allocate((Object)ATypeTag.RECORD);
    }

    private IAsterixListBuilder getOrderedListBuilder() {
        return (IAsterixListBuilder)this.listBuilderPool.allocate((Object)ATypeTag.ORDEREDLIST);
    }

    private IAsterixListBuilder getUnorderedListBuilder() {
        return (IAsterixListBuilder)this.listBuilderPool.allocate((Object)ATypeTag.UNORDEREDLIST);
    }

    private ArrayBackedValueStorage getTempBuffer() {
        return (ArrayBackedValueStorage)this.abvsBuilderPool.allocate((Object)ATypeTag.BINARY);
    }

    private void parseToBinaryTarget(int lexerToken, String tokenImage, DataOutput out) throws ParseException, HyracksDataException {
        switch (lexerToken) {
            case 13: {
                this.parseHexBinaryString(tokenImage.toCharArray(), 1, tokenImage.length() - 2, out);
                break;
            }
            case 14: {
                this.parseBase64BinaryString(tokenImage.toCharArray(), 1, tokenImage.length() - 2, out);
            }
        }
    }

    private void parseToNumericTarget(ATypeTag typeTag, IAType objectType, DataOutput out) throws IOException {
        ATypeTag targetTypeTag = this.getTargetTypeTag(typeTag, objectType);
        if (targetTypeTag == null || !this.parseValue(this.admLexer.getLastTokenImage(), targetTypeTag, out)) {
            throw new ParseException("Mismatch Type, expecting a value of type " + objectType.getTypeName() + " got a value of type " + typeTag);
        }
    }

    private void parseAndCastNumeric(ATypeTag typeTag, IAType objectType, DataOutput out) throws IOException {
        ATypeTag targetTypeTag = this.getTargetTypeTag(typeTag, objectType);
        DataOutput dataOutput = out;
        if (targetTypeTag != typeTag) {
            this.castBuffer.reset();
            dataOutput = this.castBuffer.getDataOutput();
        }
        if (targetTypeTag == null || !this.parseValue(this.admLexer.getLastTokenImage(), typeTag, dataOutput)) {
            throw new ParseException("Mismatch Type, expecting a value of type " + objectType.getTypeName() + " got a value of type " + typeTag);
        }
        if (targetTypeTag != typeTag) {
            if (ATypeHierarchy.canPromote((ATypeTag)typeTag, (ATypeTag)targetTypeTag)) {
                ITypeConvertComputer promoteComputer = ATypeHierarchy.getTypePromoteComputer((ATypeTag)typeTag, (ATypeTag)targetTypeTag);
                if (promoteComputer == null) {
                    throw new ParseException(3072, new Serializable[]{typeTag, targetTypeTag});
                }
                promoteComputer.convertType(this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1, out);
            } else if (ATypeHierarchy.canDemote((ATypeTag)typeTag, (ATypeTag)targetTypeTag)) {
                ITypeConvertComputer demoteComputer = ATypeHierarchy.getTypeDemoteComputer((ATypeTag)typeTag, (ATypeTag)targetTypeTag);
                if (demoteComputer == null) {
                    throw new ParseException(3072, new Serializable[]{typeTag, targetTypeTag});
                }
                demoteComputer.convertType(this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1, out);
            }
        }
    }

    private void parseConstructor(ATypeTag typeTag, IAType objectType, DataOutput out) throws IOException {
        ATypeTag targetTypeTag = this.getTargetTypeTag(typeTag, objectType);
        if (targetTypeTag != null) {
            int token;
            DataOutput dataOutput = out;
            if (targetTypeTag != typeTag) {
                this.castBuffer.reset();
                dataOutput = this.castBuffer.getDataOutput();
            }
            if ((token = this.admLexer.next()) == 29 && (token = this.admLexer.next()) == 38) {
                String unquoted = this.admLexer.getLastTokenImage().substring(1, this.admLexer.getLastTokenImage().length() - 1);
                if (!this.parseValue(unquoted, typeTag, dataOutput)) {
                    throw new ParseException(3073, new Serializable[]{AdmLexer.tokenKindToString(token)});
                }
                token = this.admLexer.next();
                if (token == 30) {
                    if (targetTypeTag != typeTag) {
                        ITypeConvertComputer promoteComputer = ATypeHierarchy.getTypePromoteComputer((ATypeTag)typeTag, (ATypeTag)targetTypeTag);
                        assert (promoteComputer != null);
                        promoteComputer.convertType(this.castBuffer.getByteArray(), this.castBuffer.getStartOffset() + 1, this.castBuffer.getLength() - 1, out);
                    }
                    return;
                }
            }
        }
        throw new ParseException(3054, new Serializable[]{objectType.getTypeName() + " got " + typeTag});
    }

    private boolean parseValue(String unquoted, ATypeTag typeTag, DataOutput out) throws HyracksDataException {
        switch (typeTag) {
            case BOOLEAN: {
                this.parseBoolean(unquoted, out);
                return true;
            }
            case INT8: {
                this.parseInt8(unquoted, out);
                return true;
            }
            case INT16: {
                this.parseInt16(unquoted, out);
                return true;
            }
            case INT32: {
                this.parseInt32(unquoted, out);
                return true;
            }
            case INT64: {
                this.parseInt64(unquoted, out);
                return true;
            }
            case FLOAT: {
                this.aFloat.setValue(Float.parseFloat(unquoted));
                this.floatSerde.serialize((Object)this.aFloat, out);
                return true;
            }
            case DOUBLE: {
                this.aDouble.setValue(Double.parseDouble(unquoted));
                this.doubleSerde.serialize((Object)this.aDouble, out);
                return true;
            }
            case STRING: {
                this.aString.setValue(unquoted);
                this.stringSerde.serialize((Object)this.aString, out);
                return true;
            }
            case TIME: {
                this.parseTime(unquoted, out);
                return true;
            }
            case DATE: {
                this.parseDate(unquoted, out);
                return true;
            }
            case DATETIME: {
                this.parseDateTime(unquoted, out);
                return true;
            }
            case DURATION: {
                this.parseDuration(unquoted, out);
                return true;
            }
            case DAYTIMEDURATION: {
                this.parseDateTimeDuration(unquoted, out);
                return true;
            }
            case YEARMONTHDURATION: {
                this.parseYearMonthDuration(unquoted, out);
                return true;
            }
            case POINT: {
                this.parsePoint(unquoted, out);
                return true;
            }
            case POINT3D: {
                this.parse3DPoint(unquoted, out);
                return true;
            }
            case CIRCLE: {
                this.parseCircle(unquoted, out);
                return true;
            }
            case RECTANGLE: {
                this.parseRectangle(unquoted, out);
                return true;
            }
            case LINE: {
                this.parseLine(unquoted, out);
                return true;
            }
            case POLYGON: {
                APolygonSerializerDeserializer.parse((String)unquoted, (DataOutput)out);
                return true;
            }
            case UUID: {
                this.aUUID.parseUUIDString(unquoted);
                this.uuidSerde.serialize((Object)this.aUUID, out);
                return true;
            }
        }
        return false;
    }

    private void parseBoolean(String bool, DataOutput out) throws HyracksDataException {
        if (bool.equals("true")) {
            this.booleanSerde.serialize((Object)ABoolean.TRUE, out);
        } else if (bool.equals("false")) {
            this.booleanSerde.serialize((Object)ABoolean.FALSE, out);
        } else {
            throw new ParseException(3074, new Serializable[]{"boolean"});
        }
    }

    private void parseInt8(String int8, DataOutput out) throws HyracksDataException {
        boolean positive = true;
        byte value = 0;
        int offset = 0;
        if (int8.charAt(offset) == '+') {
            ++offset;
        } else if (int8.charAt(offset) == '-') {
            ++offset;
            positive = false;
        }
        while (offset < int8.length()) {
            if (int8.charAt(offset) < '0' || int8.charAt(offset) > '9') {
                if (int8.charAt(offset) == 'i' && int8.charAt(offset + 1) == '8' && offset + 2 == int8.length()) break;
                throw new ParseException(3074, new Serializable[]{"int8"});
            }
            value = (byte)(value * 10 + int8.charAt(offset) - 48);
            ++offset;
        }
        if (value < 0) {
            throw new ParseException(3074, new Serializable[]{"int8"});
        }
        if (value > 0 && !positive) {
            value = (byte)(value * -1);
        }
        this.aInt8.setValue(value);
        this.int8Serde.serialize((Object)this.aInt8, out);
    }

    private void parseInt16(String int16, DataOutput out) throws HyracksDataException {
        boolean positive = true;
        short value = 0;
        int offset = 0;
        if (int16.charAt(offset) == '+') {
            ++offset;
        } else if (int16.charAt(offset) == '-') {
            ++offset;
            positive = false;
        }
        while (offset < int16.length()) {
            if (int16.charAt(offset) < '0' || int16.charAt(offset) > '9') {
                if (int16.charAt(offset) == 'i' && int16.charAt(offset + 1) == '1' && int16.charAt(offset + 2) == '6' && offset + 3 == int16.length()) break;
                throw new ParseException(3074, new Serializable[]{"int16"});
            }
            value = (short)(value * 10 + int16.charAt(offset) - 48);
            ++offset;
        }
        if (value < 0) {
            throw new ParseException(3074, new Serializable[]{"int16"});
        }
        if (value > 0 && !positive) {
            value = (short)(value * -1);
        }
        this.aInt16.setValue(value);
        this.int16Serde.serialize((Object)this.aInt16, out);
    }

    private void parseInt32(String int32, DataOutput out) throws HyracksDataException {
        boolean positive = true;
        int value = 0;
        int offset = 0;
        if (int32.charAt(offset) == '+') {
            ++offset;
        } else if (int32.charAt(offset) == '-') {
            ++offset;
            positive = false;
        }
        while (offset < int32.length()) {
            if (int32.charAt(offset) < '0' || int32.charAt(offset) > '9') {
                if (int32.charAt(offset) == 'i' && int32.charAt(offset + 1) == '3' && int32.charAt(offset + 2) == '2' && offset + 3 == int32.length()) break;
                throw new ParseException(3074, new Serializable[]{"int32"});
            }
            value = value * 10 + int32.charAt(offset) - 48;
            ++offset;
        }
        if (value < 0) {
            throw new ParseException(3074, new Serializable[]{"int32"});
        }
        if (value > 0 && !positive) {
            value *= -1;
        }
        this.aInt32.setValue(value);
        this.int32Serde.serialize((Object)this.aInt32, out);
    }

    private void parseInt64(String int64, DataOutput out) throws HyracksDataException {
        boolean positive = true;
        long value = 0L;
        int offset = 0;
        if (int64.charAt(offset) == '+') {
            ++offset;
        } else if (int64.charAt(offset) == '-') {
            ++offset;
            positive = false;
        }
        while (offset < int64.length()) {
            if (int64.charAt(offset) < '0' || int64.charAt(offset) > '9') {
                if (int64.charAt(offset) == 'i' && int64.charAt(offset + 1) == '6' && int64.charAt(offset + 2) == '4' && offset + 3 == int64.length()) break;
                throw new ParseException(3074, new Serializable[]{"int64"});
            }
            value = value * 10L + (long)int64.charAt(offset) - 48L;
            ++offset;
        }
        if (value < 0L) {
            throw new ParseException(3074, new Serializable[]{"int64"});
        }
        if (value > 0L && !positive) {
            value *= -1L;
        }
        this.aInt64.setValue(value);
        this.int64Serde.serialize((Object)this.aInt64, out);
    }

    private void resetPools() {
        this.listBuilderPool.reset();
        this.recordBuilderPool.reset();
        this.abvsBuilderPool.reset();
    }

    @Override
    public boolean reset(InputStream in) throws IOException {
        this.admLexer.reInit(new InputStreamReader(in));
        return true;
    }

    static class ParseException
    extends HyracksDataException {
        private static final long serialVersionUID = 1L;
        private String filename;
        private int line = -1;
        private int column = -1;

        public ParseException(String message) {
            super(message);
        }

        public ParseException(int errorCode, Serializable ... param) {
            super("ASX", errorCode, ErrorCode.getErrorMessage((int)errorCode), param);
        }

        public ParseException(int errorCode, Throwable e, Serializable ... param) {
            super("ASX", errorCode, e, new Serializable[]{ErrorCode.getErrorMessage((int)errorCode), param});
            this.addSuppressed(e);
        }

        public ParseException(Throwable cause) {
            super(cause);
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public ParseException(Throwable cause, String filename, int line, int column) {
            super(cause);
            this.setLocation(filename, line, column);
        }

        public void setLocation(String filename, int line, int column) {
            this.filename = filename;
            this.line = line;
            this.column = column;
        }

        public String getMessage() {
            StringBuilder msg = new StringBuilder("Parse error");
            if (this.filename != null) {
                msg.append(" in file " + this.filename);
            }
            if (this.line >= 0) {
                if (this.column >= 0) {
                    msg.append(" at (" + this.line + ", " + this.column + ")");
                } else {
                    msg.append(" in line " + this.line);
                }
            }
            return msg.append(": " + super.getMessage()).toString();
        }
    }
}

