/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.common.api.IAppRuntimeContext;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.common.library.ILibraryManager;
import org.apache.asterix.external.api.IAdapterFactory;
import org.apache.asterix.external.feed.api.IFeed;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.operators.FeedIntakeOperatorNodePushable;
import org.apache.asterix.om.types.ARecordType;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.base.AbstractSingleActivityOperatorDescriptor;

public class FeedIntakeOperatorDescriptor
extends AbstractSingleActivityOperatorDescriptor {
    private static final String FEED_EXTENSION_NAME = "Feed";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(FeedIntakeOperatorDescriptor.class.getName());
    private final EntityId feedId;
    private final FeedPolicyAccessor policyAccessor;
    private final ARecordType adapterOutputType;
    private IAdapterFactory adaptorFactory;
    private String adaptorLibraryName;
    private String adaptorFactoryClassName;
    private Map<String, String> adaptorConfiguration;

    public FeedIntakeOperatorDescriptor(JobSpecification spec, IFeed primaryFeed, IAdapterFactory adapterFactory, ARecordType adapterOutputType, FeedPolicyAccessor policyAccessor, RecordDescriptor rDesc) {
        super((IOperatorDescriptorRegistry)spec, 0, 1);
        this.feedId = new EntityId(FEED_EXTENSION_NAME, primaryFeed.getDataverseName(), primaryFeed.getFeedName());
        this.adaptorFactory = adapterFactory;
        this.adapterOutputType = adapterOutputType;
        this.policyAccessor = policyAccessor;
        this.recordDescriptors[0] = rDesc;
    }

    public FeedIntakeOperatorDescriptor(JobSpecification spec, IFeed primaryFeed, String adapterLibraryName, String adapterFactoryClassName, ARecordType adapterOutputType, FeedPolicyAccessor policyAccessor, RecordDescriptor rDesc) {
        super((IOperatorDescriptorRegistry)spec, 0, 1);
        this.feedId = new EntityId(FEED_EXTENSION_NAME, primaryFeed.getDataverseName(), primaryFeed.getFeedName());
        this.adaptorFactoryClassName = adapterFactoryClassName;
        this.adaptorLibraryName = adapterLibraryName;
        this.adaptorConfiguration = primaryFeed.getAdapterConfiguration();
        this.adapterOutputType = adapterOutputType;
        this.policyAccessor = policyAccessor;
        this.recordDescriptors[0] = rDesc;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        if (this.adaptorFactory == null) {
            this.adaptorFactory = this.createExternalAdapterFactory(ctx);
        }
        return new FeedIntakeOperatorNodePushable(ctx, this.feedId, this.adaptorFactory, partition, this.policyAccessor, recordDescProvider, this);
    }

    private IAdapterFactory createExternalAdapterFactory(IHyracksTaskContext ctx) throws HyracksDataException {
        IAdapterFactory adapterFactory;
        IAppRuntimeContext runtimeCtx = (IAppRuntimeContext)ctx.getJobletContext().getServiceContext().getApplicationContext();
        ILibraryManager libraryManager = runtimeCtx.getLibraryManager();
        ClassLoader classLoader = libraryManager.getLibraryClassLoader(this.feedId.getDataverse(), this.adaptorLibraryName);
        if (classLoader != null) {
            try {
                adapterFactory = (IAdapterFactory)classLoader.loadClass(this.adaptorFactoryClassName).newInstance();
                adapterFactory.setOutputType(this.adapterOutputType);
                adapterFactory.configure(libraryManager, this.adaptorConfiguration);
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        } else {
            RuntimeDataException err = new RuntimeDataException(3004, new Serializable[]{this.adaptorLibraryName, this.feedId.getDataverse()});
            LOGGER.severe(err.getMessage());
            throw err;
        }
        return adapterFactory;
    }

    public EntityId getEntityId() {
        return this.feedId;
    }

    public IAdapterFactory getAdaptorFactory() {
        return this.adaptorFactory;
    }

    public void setAdaptorFactory(IAdapterFactory factory) {
        this.adaptorFactory = factory;
    }

    public ARecordType getAdapterOutputType() {
        return this.adapterOutputType;
    }

    public FeedPolicyAccessor getPolicyAccessor() {
        return this.policyAccessor;
    }

    public String getAdaptorLibraryName() {
        return this.adaptorLibraryName;
    }

    public String getAdaptorFactoryClassName() {
        return this.adaptorFactoryClassName;
    }
}

