/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.nio.ByteBuffer;
import org.apache.asterix.external.adapter.factory.LookupAdapterFactory;
import org.apache.asterix.external.dataset.adapter.LookupAdapter;
import org.apache.asterix.external.indexing.ExternalFileIndexAccessor;
import org.apache.asterix.external.indexing.FilesIndexDescription;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManagerProvider;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.lsm.btree.dataflow.ExternalBTreeDataflowHelper;
import org.apache.hyracks.storage.common.IStorageManager;

public class ExternalLookupOperatorDescriptor
extends AbstractTreeIndexOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final LookupAdapterFactory<?> adapterFactory;

    public ExternalLookupOperatorDescriptor(IOperatorDescriptorRegistry spec, LookupAdapterFactory<?> adapterFactory, RecordDescriptor outRecDesc, IIndexDataflowHelperFactory externalFilesIndexDataFlowHelperFactory, boolean propagateInput, IIndexLifecycleManagerProvider lcManagerProvider, IStorageManager storageManager, IFileSplitProvider fileSplitProvider, ISearchOperationCallbackFactory searchOpCallbackFactory, boolean retainMissing, IMissingWriterFactory missingWriterFactory, IPageManagerFactory pageManagerFactory) {
        super(spec, 1, 1, outRecDesc, storageManager, lcManagerProvider, fileSplitProvider, new FilesIndexDescription().EXTERNAL_FILE_INDEX_TYPE_TRAITS, FilesIndexDescription.FILES_INDEX_COMP_FACTORIES, FilesIndexDescription.BLOOM_FILTER_FIELDS, externalFilesIndexDataFlowHelperFactory, null, propagateInput, retainMissing, missingWriterFactory, null, searchOpCallbackFactory, null, pageManagerFactory);
        this.adapterFactory = adapterFactory;
    }

    public IOperatorNodePushable createPushRuntime(final IHyracksTaskContext ctx, final IRecordDescriptorProvider recordDescProvider, final int partition, int nPartitions) throws HyracksDataException {
        final ExternalFileIndexAccessor snapshotAccessor = new ExternalFileIndexAccessor((ExternalBTreeDataflowHelper)this.dataflowHelperFactory.createIndexDataflowHelper((IIndexOperatorDescriptor)this, ctx, partition), this);
        return new AbstractUnaryInputUnaryOutputOperatorNodePushable(){
            private LookupAdapter<?> adapter;
            private boolean indexOpen = false;

            public void open() throws HyracksDataException {
                try {
                    this.adapter = ExternalLookupOperatorDescriptor.this.adapterFactory.createAdapter(ctx, partition, recordDescProvider.getInputRecordDescriptor(ExternalLookupOperatorDescriptor.this.getActivityId(), 0), snapshotAccessor, this.writer);
                    snapshotAccessor.open();
                    this.indexOpen = true;
                    this.adapter.open();
                }
                catch (Throwable th) {
                    throw new HyracksDataException(th);
                }
            }

            public void close() throws HyracksDataException {
                HyracksDataException hde = null;
                if (this.indexOpen) {
                    try {
                        snapshotAccessor.close();
                    }
                    catch (Throwable th) {
                        hde = new HyracksDataException(th);
                    }
                    try {
                        this.adapter.close();
                    }
                    catch (Throwable th) {
                        if (hde == null) {
                            hde = new HyracksDataException(th);
                        }
                        hde.addSuppressed(th);
                    }
                }
            }

            public void fail() throws HyracksDataException {
                try {
                    this.adapter.fail();
                }
                catch (Throwable th) {
                    throw new HyracksDataException(th);
                }
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                try {
                    this.adapter.nextFrame(buffer);
                }
                catch (Throwable th) {
                    throw new HyracksDataException(th);
                }
            }

            public void flush() throws HyracksDataException {
                this.adapter.flush();
            }
        };
    }
}

