/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.FileIndexTupleTranslator;
import org.apache.asterix.external.indexing.FilesIndexDescription;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorNodePushable;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.common.api.IIndex;
import org.apache.hyracks.storage.am.common.api.IIndexBulkLoader;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.api.IIndexLifecycleManagerProvider;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.IPageManagerFactory;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.api.IndexException;
import org.apache.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import org.apache.hyracks.storage.am.common.impls.NoOpOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.ExternalBTree;
import org.apache.hyracks.storage.common.IStorageManager;
import org.apache.hyracks.storage.common.file.ILocalResourceFactoryProvider;

public class ExternalFilesIndexOperatorDescriptor
extends AbstractTreeIndexOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private boolean createNewIndex;
    private List<ExternalFile> files;

    public ExternalFilesIndexOperatorDescriptor(IOperatorDescriptorRegistry spec, IStorageManager storageManager, IIndexLifecycleManagerProvider lifecycleManagerProvider, IFileSplitProvider fileSplitProvider, IIndexDataflowHelperFactory dataflowHelperFactory, ILocalResourceFactoryProvider localResourceFactoryProvider, List<ExternalFile> files, boolean createNewIndex, IMetadataPageManagerFactory metadataPageManagerFactory) {
        super(spec, 0, 0, null, storageManager, lifecycleManagerProvider, fileSplitProvider, new FilesIndexDescription().EXTERNAL_FILE_INDEX_TYPE_TRAITS, FilesIndexDescription.FILES_INDEX_COMP_FACTORIES, FilesIndexDescription.BLOOM_FILTER_FIELDS, dataflowHelperFactory, null, false, false, null, localResourceFactoryProvider, (ISearchOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, (IModificationOperationCallbackFactory)NoOpOperationCallbackFactory.INSTANCE, (IPageManagerFactory)metadataPageManagerFactory);
        this.createNewIndex = createNewIndex;
        this.files = files;
    }

    public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
        final IIndexDataflowHelper indexHelper = this.getIndexDataflowHelperFactory().createIndexDataflowHelper((IIndexOperatorDescriptor)this, ctx, partition);
        return new AbstractOperatorNodePushable(){

            public void initialize() throws HyracksDataException {
                FileIndexTupleTranslator filesTupleTranslator = new FileIndexTupleTranslator();
                if (ExternalFilesIndexOperatorDescriptor.this.createNewIndex) {
                    indexHelper.create();
                    indexHelper.open();
                    try {
                        IIndex index = indexHelper.getIndexInstance();
                        IIndexBulkLoader bulkLoader = index.createBulkLoader(0.7f, false, (long)ExternalFilesIndexOperatorDescriptor.this.files.size(), false);
                        for (ExternalFile file : ExternalFilesIndexOperatorDescriptor.this.files) {
                            bulkLoader.add(filesTupleTranslator.getTupleFromFile(file));
                        }
                        bulkLoader.end();
                    }
                    catch (IOException | IndexException e) {
                        throw new HyracksDataException(e);
                    }
                    finally {
                        indexHelper.close();
                    }
                }
                indexHelper.open();
                IIndex index = indexHelper.getIndexInstance();
                ExternalBTree.LSMTwoPCBTreeBulkLoader bulkLoader = null;
                try {
                    bulkLoader = (ExternalBTree.LSMTwoPCBTreeBulkLoader)((ExternalBTree)index).createTransactionBulkLoader(0.7f, false, (long)ExternalFilesIndexOperatorDescriptor.this.files.size(), false);
                    for (ExternalFile file : ExternalFilesIndexOperatorDescriptor.this.files) {
                        switch (file.getPendingOp()) {
                            case ADD_OP: 
                            case APPEND_OP: {
                                bulkLoader.add(filesTupleTranslator.getTupleFromFile(file));
                                break;
                            }
                            case DROP_OP: {
                                bulkLoader.delete(filesTupleTranslator.getTupleFromFile(file));
                            }
                        }
                    }
                    bulkLoader.end();
                }
                catch (IOException | IndexException e) {
                    if (bulkLoader != null) {
                        bulkLoader.abort();
                    }
                    throw new HyracksDataException(e);
                }
                finally {
                    indexHelper.close();
                }
            }

            public void deinitialize() throws HyracksDataException {
            }

            public int getInputArity() {
                return 0;
            }

            public void setOutputFrameWriter(int index, IFrameWriter writer, RecordDescriptor recordDesc) throws HyracksDataException {
            }

            public IFrameWriter getInputFrameWriter(int index) {
                return null;
            }
        };
    }
}

