/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.SerializerDeserializerUtil;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.library.java.JObjects;
import org.apache.asterix.om.base.APoint;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectPool;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;

public class JObjectUtil {
    public static String getNormalizedString(String originalString) {
        int len = originalString.length();
        char[] asciiBuff = new char[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char c = originalString.charAt(i);
            if (c == '\n' || c == '\t' || c == '\r') {
                asciiBuff[j] = 32;
                ++j;
                continue;
            }
            if (c <= '\u0000' || c > '\u007f') continue;
            asciiBuff[j] = c;
            ++j;
        }
        return new String(asciiBuff).trim();
    }

    public static IJObject getJType(ATypeTag typeTag, IAType type, JObjects.ByteArrayAccessibleDataInputStream dis, IObjectPool<IJObject, IAType> objectPool) throws IOException {
        IJObject jObject;
        switch (typeTag) {
            case INT32: {
                int v = dis.readInt();
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINT32);
                ((JObjects.JInt)jObject).setValue(v);
                break;
            }
            case FLOAT: {
                float v = dis.readFloat();
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AFLOAT);
                ((JObjects.JFloat)jObject).setValue(v);
                break;
            }
            case DOUBLE: {
                double value = dis.readDouble();
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADOUBLE);
                ((JObjects.JDouble)jObject).setValue(value);
                break;
            }
            case STRING: {
                String v = dis.readUTF();
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ASTRING);
                ((JObjects.JString)jObject).setValue(v);
                break;
            }
            case BOOLEAN: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ABOOLEAN);
                ((JObjects.JBoolean)jObject).setValue(dis.readBoolean());
                break;
            }
            case DATE: {
                int d = dis.readInt();
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADATE);
                ((JObjects.JDate)jObject).setValue(d);
                break;
            }
            case DATETIME: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADATETIME);
                long value = dis.readLong();
                ((JObjects.JDateTime)jObject).setValue(value);
                break;
            }
            case DURATION: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ADURATION);
                int months = dis.readInt();
                long msecs = dis.readLong();
                ((JObjects.JDuration)jObject).setValue(months, msecs);
                break;
            }
            case TIME: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ATIME);
                int time = dis.readInt();
                ((JObjects.JTime)jObject).setValue(time);
                break;
            }
            case INTERVAL: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.AINTERVAL);
                long start = dis.readLong();
                long end = dis.readLong();
                byte intervalType = dis.readByte();
                ((JObjects.JInterval)jObject).setValue(start, end, intervalType);
                break;
            }
            case CIRCLE: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ACIRCLE);
                double x = dis.readDouble();
                double y = dis.readDouble();
                double radius = dis.readDouble();
                JObjects.JPoint jpoint = (JObjects.JPoint)objectPool.allocate((Object)BuiltinType.APOINT);
                jpoint.setValue(x, y);
                ((JObjects.JCircle)jObject).setValue(jpoint, radius);
                break;
            }
            case POINT: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.APOINT);
                double x = dis.readDouble();
                double y = dis.readDouble();
                ((JObjects.JPoint)jObject).setValue(x, y);
                break;
            }
            case POINT3D: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.APOINT3D);
                double x = dis.readDouble();
                double y = dis.readDouble();
                double z = dis.readDouble();
                ((JObjects.JPoint3D)jObject).setValue(x, y, z);
                break;
            }
            case LINE: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ALINE);
                double x1 = dis.readDouble();
                double y1 = dis.readDouble();
                double x2 = dis.readDouble();
                double y2 = dis.readDouble();
                JObjects.JPoint jpoint1 = (JObjects.JPoint)objectPool.allocate((Object)BuiltinType.APOINT);
                jpoint1.setValue(x1, y1);
                JObjects.JPoint jpoint2 = (JObjects.JPoint)objectPool.allocate((Object)BuiltinType.APOINT);
                jpoint2.setValue(x2, y2);
                ((JObjects.JLine)jObject).setValue(jpoint1, jpoint2);
                break;
            }
            case POLYGON: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.APOLYGON);
                int numberOfPoints = dis.readShort();
                ArrayList<JObjects.JPoint> points = new ArrayList<JObjects.JPoint>();
                for (int i = 0; i < numberOfPoints; ++i) {
                    JObjects.JPoint p1 = (JObjects.JPoint)objectPool.allocate((Object)BuiltinType.APOINT);
                    p1.setValue(dis.readDouble(), dis.readDouble());
                    points.add(p1);
                }
                ((JObjects.JPolygon)jObject).setValue(points.toArray(new APoint[0]));
                break;
            }
            case RECTANGLE: {
                jObject = (IJObject)objectPool.allocate((Object)BuiltinType.ARECTANGLE);
                double x1 = dis.readDouble();
                double y1 = dis.readDouble();
                double x2 = dis.readDouble();
                double y2 = dis.readDouble();
                JObjects.JPoint jpoint1 = (JObjects.JPoint)objectPool.allocate((Object)BuiltinType.APOINT);
                jpoint1.setValue(x1, y1);
                JObjects.JPoint jpoint2 = (JObjects.JPoint)objectPool.allocate((Object)BuiltinType.APOINT);
                jpoint2.setValue(x2, y2);
                ((JObjects.JRectangle)jObject).setValue(jpoint1, jpoint2);
                break;
            }
            case UNORDEREDLIST: {
                int i;
                AUnorderedListType listType = (AUnorderedListType)type;
                IAType elementType = listType.getItemType();
                jObject = (IJObject)objectPool.allocate((Object)listType);
                boolean fixedSize = false;
                ATypeTag tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(dis.readByte());
                switch (tag) {
                    case STRING: 
                    case RECORD: 
                    case ORDEREDLIST: 
                    case UNORDEREDLIST: 
                    case ANY: {
                        fixedSize = false;
                        break;
                    }
                    default: {
                        fixedSize = true;
                    }
                }
                dis.readInt();
                int numberOfitems = dis.readInt();
                if (numberOfitems <= 0) break;
                if (!fixedSize) {
                    for (i = 0; i < numberOfitems; ++i) {
                        dis.readInt();
                    }
                }
                for (i = 0; i < numberOfitems; ++i) {
                    IJObject v = JObjectUtil.getJType(elementType.getTypeTag(), elementType, dis, objectPool);
                    ((JObjects.JUnorderedList)jObject).add(v);
                }
                break;
            }
            case ORDEREDLIST: {
                int i;
                AOrderedListType listType = (AOrderedListType)type;
                IAType elementType = listType.getItemType();
                jObject = (IJObject)objectPool.allocate((Object)listType);
                boolean fixedSize = false;
                ATypeTag tag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(dis.readByte());
                switch (tag) {
                    case STRING: 
                    case RECORD: 
                    case ORDEREDLIST: 
                    case UNORDEREDLIST: 
                    case ANY: {
                        fixedSize = false;
                        break;
                    }
                    default: {
                        fixedSize = true;
                    }
                }
                dis.readInt();
                int numberOfitems = dis.readInt();
                if (numberOfitems <= 0) break;
                if (!fixedSize) {
                    for (i = 0; i < numberOfitems; ++i) {
                        dis.readInt();
                    }
                }
                for (i = 0; i < numberOfitems; ++i) {
                    IJObject v = JObjectUtil.getJType(elementType.getTypeTag(), elementType, dis, objectPool);
                    ((JObjects.JOrderedList)jObject).add(v);
                }
                break;
            }
            case RECORD: {
                ARecordType recordType = (ARecordType)type;
                int numberOfSchemaFields = recordType.getFieldTypes().length;
                byte[] recordBits = dis.getInputStream().getArray();
                boolean isExpanded = false;
                dis.getInputStream();
                int[] fieldOffsets = new int[numberOfSchemaFields];
                IJObject[] closedFields = new IJObject[numberOfSchemaFields];
                dis.skip(4L);
                if (recordType.isOpen() && (isExpanded = dis.readBoolean())) {
                    dis.readInt();
                }
                if (numberOfSchemaFields > 0) {
                    dis.readInt();
                    int nullBitMapOffset = 0;
                    boolean hasOptionalFields = NonTaggedFormatUtil.hasOptionalField((ARecordType)recordType);
                    if (hasOptionalFields) {
                        nullBitMapOffset = dis.getInputStream().getPosition();
                        dis.getInputStream();
                    } else {
                        dis.getInputStream();
                    }
                    for (int i = 0; i < numberOfSchemaFields; ++i) {
                        fieldOffsets[i] = dis.readInt();
                    }
                    for (int fieldNumber = 0; fieldNumber < numberOfSchemaFields; ++fieldNumber) {
                        int p;
                        byte b1;
                        if (hasOptionalFields && ((b1 = recordBits[nullBitMapOffset + fieldNumber / 8]) & (p = 1 << 7 - fieldNumber % 8)) == 0) continue;
                        IAType[] fieldTypes = recordType.getFieldTypes();
                        ATypeTag fieldValueTypeTag = null;
                        IAType fieldType = fieldTypes[fieldNumber];
                        if (fieldTypes[fieldNumber].getTypeTag() == ATypeTag.UNION) {
                            if (((AUnionType)fieldTypes[fieldNumber]).isUnknownableType()) {
                                fieldType = ((AUnionType)fieldTypes[fieldNumber]).getActualType();
                                fieldValueTypeTag = fieldType.getTypeTag();
                            }
                        } else {
                            fieldValueTypeTag = fieldTypes[fieldNumber].getTypeTag();
                        }
                        closedFields[fieldNumber] = JObjectUtil.getJType(fieldValueTypeTag, fieldType, dis, objectPool);
                    }
                }
                if (isExpanded) {
                    int i;
                    int numberOfOpenFields = dis.readInt();
                    String[] fieldNames = new String[numberOfOpenFields];
                    IAType[] fieldTypes = new IAType[numberOfOpenFields];
                    IJObject[] openFields = new IJObject[numberOfOpenFields];
                    for (i = 0; i < numberOfOpenFields; ++i) {
                        dis.readInt();
                        dis.readInt();
                    }
                    for (i = 0; i < numberOfOpenFields; ++i) {
                        fieldNames[i] = AStringSerializerDeserializer.INSTANCE.deserialize((DataInput)dis).getStringValue();
                        ATypeTag openFieldTypeTag = SerializerDeserializerUtil.deserializeTag((DataInput)dis);
                        openFields[i] = JObjectUtil.getJType(openFieldTypeTag, null, dis, objectPool);
                        fieldTypes[i] = openFields[i].getIAObject().getType();
                    }
                    ARecordType openPartRecType = new ARecordType(null, fieldNames, fieldTypes, true);
                    if (numberOfSchemaFields > 0) {
                        ARecordType mergedRecordType = JObjectUtil.mergeRecordTypes(recordType, openPartRecType);
                        IJObject[] mergedFields = JObjectUtil.mergeFields(closedFields, openFields);
                        IJObject jObject2 = (IJObject)objectPool.allocate((Object)recordType);
                        return new JObjects.JRecord(mergedRecordType, mergedFields);
                    }
                    return new JObjects.JRecord(recordType, openFields);
                }
                return new JObjects.JRecord(recordType, closedFields);
            }
            default: {
                throw new RuntimeDataException(3040, new Serializable[]{typeTag});
            }
        }
        return jObject;
    }

    private static IJObject[] mergeFields(IJObject[] closedFields, IJObject[] openFields) {
        IJObject[] fields = new IJObject[closedFields.length + openFields.length];
        for (int i = 0; i < closedFields.length; ++i) {
            fields[i] = closedFields[i];
        }
        for (int j = 0; j < openFields.length; ++j) {
            fields[closedFields.length + j] = openFields[j];
        }
        return fields;
    }

    private static ARecordType mergeRecordTypes(ARecordType recType1, ARecordType recType2) {
        int i;
        String[] fieldNames = new String[recType1.getFieldNames().length + recType2.getFieldNames().length];
        IAType[] fieldTypes = new IAType[recType1.getFieldTypes().length + recType2.getFieldTypes().length];
        for (i = 0; i < recType1.getFieldNames().length; ++i) {
            fieldNames[i] = recType1.getFieldNames()[i];
            fieldTypes[i] = recType1.getFieldTypes()[i];
        }
        for (int j = 0; j < recType2.getFieldNames().length; ++j) {
            fieldNames[i] = recType2.getFieldNames()[j];
            fieldTypes[i] = recType2.getFieldTypes()[j];
            ++i;
        }
        return new ARecordType(null, fieldNames, fieldTypes, true);
    }
}

