/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library;

import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.library.java.JObjects;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.AUnorderedListType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.util.container.IObjectFactory;

public class JTypeObjectFactory
implements IObjectFactory<IJObject, IAType> {
    public static final JTypeObjectFactory INSTANCE = new JTypeObjectFactory();

    private JTypeObjectFactory() {
    }

    public IJObject create(IAType type) {
        IJObject retValue = null;
        switch (type.getTypeTag()) {
            case INT32: {
                retValue = new JObjects.JInt(0);
                break;
            }
            case STRING: {
                retValue = new JObjects.JString("");
                break;
            }
            case FLOAT: {
                retValue = new JObjects.JFloat(0.0f);
                break;
            }
            case DOUBLE: {
                retValue = new JObjects.JDouble(0.0);
                break;
            }
            case BOOLEAN: {
                retValue = new JObjects.JBoolean(false);
                break;
            }
            case CIRCLE: {
                retValue = new JObjects.JCircle(new JObjects.JPoint(0.0, 0.0), 0.0);
                break;
            }
            case POINT: {
                retValue = new JObjects.JPoint(0.0, 0.0);
                break;
            }
            case POINT3D: {
                retValue = new JObjects.JPoint3D(0.0, 0.0, 0.0);
                break;
            }
            case POLYGON: {
                retValue = new JObjects.JPolygon(new JObjects.JPoint[0]);
                break;
            }
            case LINE: {
                retValue = new JObjects.JLine(new JObjects.JPoint(0.0, 0.0), new JObjects.JPoint(0.0, 0.0));
                break;
            }
            case RECTANGLE: {
                retValue = new JObjects.JRectangle(new JObjects.JPoint(0.0, 0.0), new JObjects.JPoint(1.0, 1.0));
                break;
            }
            case DATE: {
                retValue = new JObjects.JDate(0);
                break;
            }
            case DATETIME: {
                retValue = new JObjects.JDateTime(0L);
                break;
            }
            case DURATION: {
                retValue = new JObjects.JDuration(0, 0L);
                break;
            }
            case INTERVAL: {
                retValue = new JObjects.JInterval(0L, 0L);
                break;
            }
            case TIME: {
                retValue = new JObjects.JTime(0);
                break;
            }
            case INT64: {
                retValue = new JObjects.JLong(0L);
                break;
            }
            case ORDEREDLIST: {
                AOrderedListType ot = (AOrderedListType)type;
                IAType orderedItemType = ot.getItemType();
                IJObject orderedItemObject = this.create(orderedItemType);
                retValue = new JObjects.JOrderedList(orderedItemObject);
                break;
            }
            case UNORDEREDLIST: {
                AUnorderedListType ut = (AUnorderedListType)type;
                IAType unorderedItemType = ut.getItemType();
                IJObject unorderedItemObject = this.create(unorderedItemType);
                retValue = new JObjects.JUnorderedList(unorderedItemObject);
                break;
            }
            case RECORD: {
                IAType[] fieldTypes = ((ARecordType)type).getFieldTypes();
                IJObject[] fieldObjects = new IJObject[fieldTypes.length];
                int index = 0;
                for (IAType fieldType : fieldTypes) {
                    fieldObjects[index] = this.create(fieldType);
                    ++index;
                }
                retValue = new JObjects.JRecord((ARecordType)type, fieldObjects);
                break;
            }
            case UNION: {
                AUnionType unionType = (AUnionType)type;
                IJObject itemObject = null;
                if (unionType.isMissableType()) {
                    itemObject = this.create((IAType)unionType);
                }
                retValue = itemObject;
                break;
            }
        }
        return retValue;
    }
}

