/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.stream.factory;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.INodeResolver;
import org.apache.asterix.external.api.INodeResolverFactory;
import org.apache.asterix.external.input.stream.LocalFSInputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.FileSystemWatcher;
import org.apache.asterix.external.util.NodeResolverFactory;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.UnmanagedFileSplit;

public class LocalFSInputStreamFactory
implements IInputStreamFactory {
    private static final long serialVersionUID = 1L;
    protected static final INodeResolver DEFAULT_NODE_RESOLVER = new NodeResolverFactory().createNodeResolver();
    protected static final Logger LOGGER = Logger.getLogger(LocalFSInputStreamFactory.class.getName());
    protected static INodeResolver nodeResolver;
    protected Map<String, String> configuration;
    protected UnmanagedFileSplit[] inputFileSplits;
    protected boolean isFeed;
    protected String expression;
    private transient AlgebricksAbsolutePartitionConstraint constraints;
    private transient FileSystemWatcher watcher;

    @Override
    public synchronized AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        if (this.watcher == null) {
            String nodeName = ctx.getJobletContext().getServiceContext().getNodeId();
            ArrayList<Path> inputResources = new ArrayList<Path>();
            for (int i = 0; i < this.inputFileSplits.length; ++i) {
                if (!this.inputFileSplits[i].getNodeName().equals(nodeName)) continue;
                inputResources.add(this.inputFileSplits[i].getFile().toPath());
            }
            this.watcher = new FileSystemWatcher(inputResources, this.expression, this.isFeed);
        }
        return new LocalFSInputStream(this.watcher);
    }

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.STREAM;
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    @Override
    public void configure(Map<String, String> configuration) throws AsterixException {
        this.configuration = configuration;
        String[] splits = configuration.get("path").split(",");
        this.configureFileSplits(splits);
        this.configurePartitionConstraint();
        this.isFeed = ExternalDataUtils.isFeed(configuration) && ExternalDataUtils.keepDataSourceOpen(configuration);
        this.expression = configuration.get("expression");
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() {
        return this.constraints;
    }

    private void configureFileSplits(String[] splits) throws AsterixException {
        INodeResolver resolver = this.getNodeResolver();
        if (this.inputFileSplits == null) {
            this.inputFileSplits = new UnmanagedFileSplit[splits.length];
            int count = 0;
            for (String splitPath : splits) {
                String trimmedValue = splitPath.trim();
                if (!trimmedValue.contains("://")) {
                    throw new AsterixException("Invalid path: " + splitPath + "\nUsage- path=\"Host://Absolute File Path\"");
                }
                String node = resolver.resolveNode(trimmedValue.split(":")[0]);
                String path = trimmedValue.split("://")[1];
                this.inputFileSplits[count++] = new UnmanagedFileSplit(node, path);
            }
        }
    }

    private void configurePartitionConstraint() throws AsterixException {
        TreeSet<String> locs = new TreeSet<String>();
        for (int i = 0; i < this.inputFileSplits.length; ++i) {
            locs.add(this.inputFileSplits[i].getNodeName());
        }
        this.constraints = new AlgebricksAbsolutePartitionConstraint(locs.toArray(new String[locs.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected INodeResolver getNodeResolver() {
        if (nodeResolver == null) {
            INodeResolver iNodeResolver = DEFAULT_NODE_RESOLVER;
            synchronized (iNodeResolver) {
                if (nodeResolver == null) {
                    nodeResolver = LocalFSInputStreamFactory.initializeNodeResolver();
                }
            }
        }
        return nodeResolver;
    }

    private static INodeResolver initializeNodeResolver() {
        INodeResolver nodeResolver = null;
        String configuredNodeResolverFactory = System.getProperty("node.Resolver");
        if (configuredNodeResolverFactory != null) {
            try {
                nodeResolver = ((INodeResolverFactory)Class.forName(configuredNodeResolverFactory).newInstance()).createNodeResolver();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Unable to create node resolver from the configured classname " + configuredNodeResolverFactory + "\n" + e.getMessage());
                }
                nodeResolver = DEFAULT_NODE_RESOLVER;
            }
        } else {
            nodeResolver = DEFAULT_NODE_RESOLVER;
        }
        return nodeResolver;
    }
}

