/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.util.Map;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IInputStreamFactory;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.provider.StreamRecordReaderProvider;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class StreamRecordReaderFactory
implements IRecordReaderFactory<char[]> {
    private static final long serialVersionUID = 1L;
    protected final IInputStreamFactory streamFactory;
    protected Map<String, String> configuration;
    protected StreamRecordReaderProvider.Format format;

    public StreamRecordReaderFactory(IInputStreamFactory inputStreamFactory) {
        this.streamFactory = inputStreamFactory;
    }

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public Class<?> getRecordClass() {
        return char[].class;
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        return this.streamFactory.getPartitionConstraint();
    }

    @Override
    public void configure(Map<String, String> configuration) throws HyracksDataException, AlgebricksException {
        this.configuration = configuration;
        this.streamFactory.configure(configuration);
        this.format = StreamRecordReaderProvider.getReaderFormat(configuration);
    }

    @Override
    public IRecordReader<? extends char[]> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return StreamRecordReaderProvider.createRecordReader(this.format, this.streamFactory.createInputStream(ctx, partition), this.configuration);
    }
}

