/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import org.apache.asterix.common.exceptions.ExceptionUtils;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.stream.LineRecordReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class QuotedLineRecordReader
extends LineRecordReader {
    private final char quote;
    private boolean prevCharEscape;
    private boolean inQuote;

    public QuotedLineRecordReader(boolean hasHeader, AsterixInputStream stream, String quoteString) throws HyracksDataException {
        super(hasHeader, stream);
        if (quoteString == null || quoteString.length() != 1) {
            throw new HyracksDataException(ExceptionUtils.incorrectParameterMessage((String)"quote", (String)"Value of size 1", (String)quoteString));
        }
        this.quote = quoteString.charAt(0);
    }

    @Override
    public boolean hasNext() throws IOException {
        while (true) {
            if (this.done) {
                return false;
            }
            this.newlineLength = 0;
            this.prevCharCR = false;
            this.prevCharEscape = false;
            this.record.reset();
            int readLength = 0;
            this.inQuote = false;
            do {
                int startPosn = this.bufferPosn;
                if (this.bufferPosn >= this.bufferLength) {
                    this.bufferPosn = 0;
                    startPosn = 0;
                    this.bufferLength = this.reader.read(this.inputBuffer);
                    if (this.bufferLength <= 0) {
                        if (readLength > 0) {
                            if (this.inQuote) {
                                throw new IOException("malformed input record ended inside quote");
                            }
                            this.record.endRecord();
                            ++this.recordNumber;
                            return true;
                        }
                        this.close();
                        return false;
                    }
                }
                while (this.bufferPosn < this.bufferLength) {
                    if (!this.inQuote) {
                        if (this.inputBuffer[this.bufferPosn] == '\n') {
                            this.newlineLength = this.prevCharCR ? 2 : 1;
                            ++this.bufferPosn;
                            break;
                        }
                        if (this.prevCharCR) {
                            this.newlineLength = 1;
                            break;
                        }
                        boolean bl = this.prevCharCR = this.inputBuffer[this.bufferPosn] == '\r';
                        if (this.inputBuffer[this.bufferPosn] == this.quote && !this.prevCharEscape) {
                            this.inQuote = true;
                        }
                        this.prevCharEscape = this.prevCharEscape ? false : this.inputBuffer[this.bufferPosn] == '\\';
                    } else {
                        if (this.inputBuffer[this.bufferPosn] == this.quote && !this.prevCharEscape) {
                            this.inQuote = false;
                        }
                        this.prevCharEscape = this.inputBuffer[this.bufferPosn] == '\\';
                    }
                    ++this.bufferPosn;
                }
                readLength = this.bufferPosn - startPosn;
                if (this.prevCharCR && this.newlineLength == 0) {
                    --readLength;
                }
                if (readLength <= 0) continue;
                this.record.append(this.inputBuffer, startPosn, readLength);
            } while (this.newlineLength == 0);
            if (!this.nextIsHeader) break;
            this.nextIsHeader = false;
        }
        ++this.recordNumber;
        return true;
    }
}

