/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class LineRecordReader
extends StreamRecordReader {
    private final boolean hasHeader;
    protected boolean prevCharCR;
    protected int newlineLength;
    protected int recordNumber = 0;
    protected boolean nextIsHeader = false;

    public LineRecordReader(boolean hasHeader, AsterixInputStream stream) throws HyracksDataException {
        super(stream);
        this.hasHeader = hasHeader;
        if (hasHeader) {
            stream.setNotificationHandler(this);
        }
    }

    @Override
    public void notifyNewSource() {
        if (this.hasHeader) {
            this.nextIsHeader = true;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        while (true) {
            if (this.done) {
                return false;
            }
            this.newlineLength = 0;
            this.prevCharCR = false;
            this.record.reset();
            int readLength = 0;
            do {
                int startPosn = this.bufferPosn;
                if (this.bufferPosn >= this.bufferLength) {
                    this.bufferPosn = 0;
                    startPosn = 0;
                    this.bufferLength = this.reader.read(this.inputBuffer);
                    if (this.bufferLength <= 0) {
                        if (readLength > 0) {
                            this.record.endRecord();
                            ++this.recordNumber;
                            return true;
                        }
                        this.close();
                        return false;
                    }
                }
                while (this.bufferPosn < this.bufferLength) {
                    if (this.inputBuffer[this.bufferPosn] == '\n') {
                        this.newlineLength = this.prevCharCR ? 2 : 1;
                        ++this.bufferPosn;
                        break;
                    }
                    if (this.prevCharCR) {
                        this.newlineLength = 1;
                        break;
                    }
                    this.prevCharCR = this.inputBuffer[this.bufferPosn] == '\r';
                    ++this.bufferPosn;
                }
                readLength = this.bufferPosn - startPosn;
                if (this.prevCharCR && this.newlineLength == 0) {
                    --readLength;
                    this.prevCharCR = false;
                }
                if (readLength <= 0) continue;
                this.record.append(this.inputBuffer, startPosn, readLength);
            } while (this.newlineLength == 0);
            if (!this.nextIsHeader) break;
            this.nextIsHeader = false;
        }
        ++this.recordNumber;
        return true;
    }
}

