/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.stream;

import java.io.IOException;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.stream.StreamRecordReader;

public class EmptyLineSeparatedRecordReader
extends StreamRecordReader {
    private boolean prevCharCR;
    private boolean prevCharLF;
    private int newlineLength;
    private int readLength;

    public EmptyLineSeparatedRecordReader(AsterixInputStream inputStream) {
        super(inputStream);
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.done) {
            return false;
        }
        if (!this.skipWhiteSpace()) {
            this.done = true;
            this.close();
            return false;
        }
        this.newlineLength = 0;
        this.prevCharCR = false;
        this.prevCharLF = false;
        this.record.reset();
        this.readLength = 0;
        do {
            int startPosn = this.bufferPosn;
            if (this.bufferPosn >= this.bufferLength) {
                this.bufferPosn = 0;
                startPosn = 0;
                this.bufferLength = this.reader.read(this.inputBuffer);
                if (this.bufferLength <= 0) {
                    if (this.readLength > 0) {
                        this.record.endRecord();
                        return true;
                    }
                    this.close();
                    return false;
                }
            }
            while (this.bufferPosn < this.bufferLength) {
                if (this.inputBuffer[this.bufferPosn] == '\n') {
                    if (this.prevCharLF) {
                        ++this.bufferPosn;
                        this.newlineLength = 2;
                        break;
                    }
                    if (this.prevCharCR) {
                        ++this.newlineLength;
                    }
                    this.prevCharLF = true;
                } else {
                    this.prevCharLF = false;
                }
                if (this.inputBuffer[this.bufferPosn] == '\r') {
                    if (this.prevCharCR) {
                        this.newlineLength = 2;
                        break;
                    }
                    this.prevCharCR = true;
                } else {
                    this.prevCharCR = false;
                }
                if (!this.prevCharCR && !this.prevCharLF) {
                    this.newlineLength = 0;
                }
                ++this.bufferPosn;
            }
            this.readLength = this.bufferPosn - startPosn;
            if (this.readLength <= 0) continue;
            this.record.append(this.inputBuffer, startPosn, this.readLength);
        } while (this.newlineLength < 2);
        this.record.endRecord();
        return true;
    }

    private boolean skipWhiteSpace() throws IOException {
        while (true) {
            if (this.bufferPosn < this.bufferLength) {
                if (!Character.isWhitespace(this.inputBuffer[this.bufferPosn])) {
                    return true;
                }
                ++this.bufferPosn;
                continue;
            }
            this.bufferPosn = 0;
            this.bufferLength = this.reader.read(this.inputBuffer);
            if (this.bufferLength < 0) break;
        }
        return false;
    }
}

