/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.asterix.external.api.IExternalDataSourceFactory;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.IRecordReaderFactory;
import org.apache.asterix.external.input.record.reader.rss.RSSRecordReader;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksAbsolutePartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RSSRecordReaderFactory
implements IRecordReaderFactory<SyndEntryImpl> {
    private static final long serialVersionUID = 1L;
    private final List<String> urls = new ArrayList<String>();
    private transient AlgebricksAbsolutePartitionConstraint clusterLocations;

    @Override
    public IExternalDataSourceFactory.DataSourceType getDataSourceType() {
        return IExternalDataSourceFactory.DataSourceType.RECORDS;
    }

    @Override
    public AlgebricksAbsolutePartitionConstraint getPartitionConstraint() throws AlgebricksException {
        int count = this.urls.size();
        this.clusterLocations = IExternalDataSourceFactory.getPartitionConstraints(this.clusterLocations, count);
        return this.clusterLocations;
    }

    @Override
    public void configure(Map<String, String> configuration) {
        String url = configuration.get("url");
        if (url == null) {
            throw new IllegalArgumentException("no RSS URL provided");
        }
        this.initializeURLs(url);
    }

    private void initializeURLs(String url) {
        String[] rssURLs;
        this.urls.clear();
        for (String rssURL : rssURLs = url.split(",")) {
            this.urls.add(rssURL);
        }
    }

    @Override
    public boolean isIndexible() {
        return false;
    }

    @Override
    public IRecordReader<? extends SyndEntryImpl> createRecordReader(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        try {
            return new RSSRecordReader(this.urls.get(partition));
        }
        catch (MalformedURLException e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    @Override
    public Class<? extends SyndEntryImpl> getRecordClass() {
        return SyndEntryImpl.class;
    }
}

