/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.fetcher.FeedFetcher;
import com.sun.syndication.fetcher.FetcherException;
import com.sun.syndication.fetcher.FetcherListener;
import com.sun.syndication.fetcher.impl.FeedFetcherCache;
import com.sun.syndication.fetcher.impl.HashMapFeedInfoCache;
import com.sun.syndication.fetcher.impl.HttpURLFeedFetcher;
import com.sun.syndication.io.FeedException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.input.record.GenericRecord;
import org.apache.asterix.external.input.record.reader.rss.FetcherEventListenerImpl;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.log4j.Logger;

public class RSSRecordReader
implements IRecordReader<SyndEntryImpl> {
    private static final Logger LOGGER = Logger.getLogger((String)RSSRecordReader.class.getName());
    private boolean modified = false;
    private Queue<SyndEntryImpl> rssFeedBuffer = new LinkedList<SyndEntryImpl>();
    private FeedFetcherCache feedInfoCache;
    private FeedFetcher fetcher;
    private FetcherEventListenerImpl listener;
    private URL feedUrl;
    private GenericRecord<SyndEntryImpl> record = new GenericRecord();
    private boolean done = false;

    public RSSRecordReader(String url) throws MalformedURLException {
        this.feedUrl = new URL(url);
        this.feedInfoCache = HashMapFeedInfoCache.getInstance();
        this.fetcher = new HttpURLFeedFetcher(this.feedInfoCache);
        this.listener = new FetcherEventListenerImpl(this, LOGGER);
        this.fetcher.addFetcherEventListener((FetcherListener)this.listener);
    }

    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void close() throws IOException {
        this.fetcher.removeFetcherEventListener((FetcherListener)this.listener);
    }

    @Override
    public boolean hasNext() throws Exception {
        return !this.done;
    }

    @Override
    public IRawRecord<SyndEntryImpl> next() throws IOException {
        if (this.done) {
            return null;
        }
        try {
            SyndEntryImpl feedEntry = this.getNextRSSFeed();
            if (feedEntry == null) {
                return null;
            }
            this.record.set(feedEntry);
            return this.record;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean stop() {
        this.done = true;
        return true;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    private SyndEntryImpl getNextRSSFeed() throws Exception {
        if (this.rssFeedBuffer.isEmpty()) {
            this.fetchFeed();
        }
        if (this.rssFeedBuffer.isEmpty()) {
            return null;
        }
        return this.rssFeedBuffer.remove();
    }

    private void fetchFeed() throws IllegalArgumentException, IOException, FeedException, FetcherException {
        SyndFeed feed = this.fetcher.retrieveFeed(this.feedUrl);
        if (this.modified) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)(this.feedUrl + " retrieved"));
                LOGGER.info((Object)(this.feedUrl + " has a title: " + feed.getTitle() + " and contains " + feed.getEntries().size() + " entries."));
            }
            List fetchedFeeds = feed.getEntries();
            this.rssFeedBuffer.addAll(fetchedFeeds);
        }
    }

    @Override
    public void setFeedLogManager(FeedLogManager feedLogManager) {
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }
}

