/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs;

import java.io.IOException;
import java.util.List;
import org.apache.asterix.external.api.IExternalIndexer;
import org.apache.asterix.external.api.IIndexingDatasource;
import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.input.record.GenericRecord;
import org.apache.asterix.external.input.record.reader.hdfs.EmptyRecordReader;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class HDFSRecordReader<K, V extends Writable>
implements IRecordReader<Writable>,
IIndexingDatasource {
    protected RecordReader<K, Writable> reader;
    protected V value = null;
    protected K key = null;
    protected int currentSplitIndex = 0;
    protected boolean[] read;
    protected InputFormat<?, ?> inputFormat;
    protected InputSplit[] inputSplits;
    protected String[] readSchedule;
    protected String nodeName;
    protected JobConf conf;
    protected GenericRecord<Writable> record;
    protected final IExternalIndexer indexer;
    protected final List<ExternalFile> snapshot;
    protected final FileSystem hdfs;

    public HDFSRecordReader(boolean[] read, InputSplit[] inputSplits, String[] readSchedule, String nodeName, JobConf conf, List<ExternalFile> snapshot, IExternalIndexer indexer) throws IOException {
        this.read = read;
        this.inputSplits = inputSplits;
        this.readSchedule = readSchedule;
        this.nodeName = nodeName;
        this.conf = conf;
        this.inputFormat = conf.getInputFormat();
        this.reader = new EmptyRecordReader<K, Writable>();
        this.record = new GenericRecord();
        this.indexer = indexer;
        this.snapshot = snapshot;
        this.hdfs = FileSystem.get((Configuration)conf);
        this.nextInputSplit();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.reader.next(this.key, this.value)) {
            return true;
        }
        while (this.nextInputSplit()) {
            if (!this.reader.next(this.key, this.value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IRawRecord<Writable> next() throws IOException {
        this.record.set((Writable)this.value);
        return this.record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean nextInputSplit() throws IOException {
        while (this.currentSplitIndex < this.inputSplits.length) {
            block5: {
                block7: {
                    block8: {
                        block6: {
                            if (!this.readSchedule[this.currentSplitIndex].equals(this.nodeName)) break block5;
                            boolean[] blArray = this.read;
                            // MONITORENTER : this.read
                            if (this.read[this.currentSplitIndex]) break block6;
                            this.read[this.currentSplitIndex] = true;
                            // MONITOREXIT : blArray
                            if (this.snapshot == null) break block7;
                            break block8;
                        }
                        // MONITOREXIT : blArray
                        break block5;
                    }
                    String fileName = ((FileSplit)this.inputSplits[this.currentSplitIndex]).getPath().toUri().getPath();
                    FileStatus fileStatus = this.hdfs.getFileStatus(new Path(fileName));
                    if (fileStatus.getModificationTime() != this.snapshot.get(this.currentSplitIndex).getLastModefiedTime().getTime()) break block5;
                }
                this.reader.close();
                this.reader = this.getRecordReader(this.currentSplitIndex);
                return true;
            }
            ++this.currentSplitIndex;
        }
        return false;
    }

    private RecordReader<K, Writable> getRecordReader(int splitIndex) throws IOException {
        this.reader = this.inputFormat.getRecordReader(this.inputSplits[splitIndex], this.conf, Reporter.NULL);
        if (this.key == null) {
            this.key = this.reader.createKey();
            this.value = (Writable)this.reader.createValue();
        }
        if (this.indexer != null) {
            try {
                this.indexer.reset(this);
            }
            catch (Exception e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
        return this.reader;
    }

    @Override
    public boolean stop() {
        return false;
    }

    @Override
    public IExternalIndexer getIndexer() {
        return this.indexer;
    }

    @Override
    public List<ExternalFile> getSnapshot() {
        return this.snapshot;
    }

    @Override
    public int getCurrentSplitIndex() {
        return this.currentSplitIndex;
    }

    public RecordReader<K, Writable> getReader() {
        return this.reader;
    }

    @Override
    public void setFeedLogManager(FeedLogManager feedLogManager) {
    }

    @Override
    public void setController(AbstractFeedDataFlowController controller) {
    }

    @Override
    public boolean handleException(Throwable th) {
        return false;
    }
}

