/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.indexing;

import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.external.indexing.ExternalFile;
import org.apache.asterix.external.indexing.FilesIndexDescription;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDateTime;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class FileIndexTupleTranslator {
    private final FilesIndexDescription filesIndexDescription = new FilesIndexDescription();
    private ArrayTupleBuilder tupleBuilder;
    private RecordBuilder recordBuilder;
    private ArrayBackedValueStorage fieldValue;
    private AMutableInt32 aInt32;
    private AMutableInt64 aInt64;
    private AMutableString aString;
    private AMutableDateTime aDateTime;
    private ISerializerDeserializer<IAObject> stringSerde;
    private ISerializerDeserializer<IAObject> dateTimeSerde;
    private ISerializerDeserializer<IAObject> longSerde;
    private ArrayTupleReference tuple;

    public FileIndexTupleTranslator() {
        this.tupleBuilder = new ArrayTupleBuilder(this.filesIndexDescription.FILE_INDEX_RECORD_DESCRIPTOR.getFieldCount());
        this.recordBuilder = new RecordBuilder();
        this.fieldValue = new ArrayBackedValueStorage();
        this.aInt32 = new AMutableInt32(0);
        this.aInt64 = new AMutableInt64(0L);
        this.aString = new AMutableString(null);
        this.aDateTime = new AMutableDateTime(0L);
        this.stringSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ASTRING);
        this.dateTimeSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADATETIME);
        this.longSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
        this.tuple = new ArrayTupleReference();
    }

    public ITupleReference getTupleFromFile(ExternalFile file) throws HyracksDataException {
        this.tupleBuilder.reset();
        this.aInt32.setValue(file.getFileNumber());
        this.filesIndexDescription.FILE_INDEX_RECORD_DESCRIPTOR.getFields()[0].serialize((Object)this.aInt32, this.tupleBuilder.getDataOutput());
        this.tupleBuilder.addFieldEndOffset();
        this.recordBuilder.reset(this.filesIndexDescription.EXTERNAL_FILE_RECORD_TYPE);
        this.fieldValue.reset();
        this.aString.setValue(file.getFileName());
        this.stringSerde.serialize((Object)this.aString, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(0, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aInt64.setValue(file.getSize());
        this.longSerde.serialize((Object)this.aInt64, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(1, (IValueReference)this.fieldValue);
        this.fieldValue.reset();
        this.aDateTime.setValue(file.getLastModefiedTime().getTime());
        this.dateTimeSerde.serialize((Object)this.aDateTime, this.fieldValue.getDataOutput());
        this.recordBuilder.addField(2, (IValueReference)this.fieldValue);
        this.recordBuilder.write(this.tupleBuilder.getDataOutput(), true);
        this.tupleBuilder.addFieldEndOffset();
        this.tuple.reset(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray());
        return this.tuple;
    }
}

