/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.runtime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveRuntime;
import org.apache.asterix.external.feed.runtime.AdapterRuntimeManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class IngestionRuntime
implements IActiveRuntime {
    private static final Logger LOGGER = Logger.getLogger(IngestionRuntime.class.getName());
    private final AdapterRuntimeManager adapterRuntimeManager;
    private final ActiveRuntimeId runtimeId;
    private final EntityId feedId;

    public IngestionRuntime(EntityId entityId, ActiveRuntimeId runtimeId, AdapterRuntimeManager adaptorRuntimeManager) {
        this.feedId = entityId;
        this.runtimeId = runtimeId;
        this.adapterRuntimeManager = adaptorRuntimeManager;
    }

    public ActiveRuntimeId getRuntimeId() {
        return this.runtimeId;
    }

    public void start() {
        this.adapterRuntimeManager.start();
        LOGGER.log(Level.INFO, "Feed " + this.feedId.getEntityName() + " running on partition " + this.runtimeId);
    }

    public void stop() throws InterruptedException, HyracksDataException {
        this.adapterRuntimeManager.stop();
        LOGGER.log(Level.INFO, "Feed " + this.feedId.getEntityName() + " stopped on partition " + this.runtimeId);
    }

    public EntityId getFeedId() {
        return this.feedId;
    }
}

