/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.runtime;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.external.dataset.adapter.FeedAdapter;
import org.apache.asterix.external.feed.runtime.AdapterExecutor;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class AdapterRuntimeManager {
    private static final Logger LOGGER = Logger.getLogger(AdapterRuntimeManager.class.getName());
    private final EntityId feedId;
    private final FeedAdapter feedAdapter;
    private final AdapterExecutor adapterExecutor;
    private final int partition;
    private final IHyracksTaskContext ctx;
    private Future<?> execution;
    private boolean started = false;
    private volatile boolean done = false;
    private volatile boolean failed = false;

    public AdapterRuntimeManager(IHyracksTaskContext ctx, EntityId entityId, FeedAdapter feedAdapter, IFrameWriter writer, int partition) {
        this.ctx = ctx;
        this.feedId = entityId;
        this.feedAdapter = feedAdapter;
        this.partition = partition;
        this.adapterExecutor = new AdapterExecutor(writer, feedAdapter, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        AdapterExecutor adapterExecutor = this.adapterExecutor;
        synchronized (adapterExecutor) {
            this.started = true;
            if (!this.done) {
                this.execution = this.ctx.getExecutorService().submit(this.adapterExecutor);
            } else {
                LOGGER.log(Level.WARNING, "Someone stopped me before I even start. I will simply not start");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws HyracksDataException, InterruptedException {
        AdapterExecutor adapterExecutor = this.adapterExecutor;
        synchronized (adapterExecutor) {
            block13: {
                try {
                    if (this.started) {
                        try {
                            this.ctx.getExecutorService().submit(() -> {
                                if (this.feedAdapter.stop()) {
                                    this.execution.get();
                                }
                                return null;
                            }).get(30L, TimeUnit.SECONDS);
                            break block13;
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.WARNING, "Interrupted while trying to stop an adapter runtime", e);
                            throw e;
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.WARNING, "Exception while trying to stop an adapter runtime", e);
                            throw HyracksDataException.create((Throwable)e);
                        }
                        finally {
                            this.execution.cancel(true);
                        }
                    }
                    LOGGER.log(Level.WARNING, "Adapter executor was stopped before it starts");
                }
                finally {
                    this.done = true;
                }
            }
        }
    }

    public EntityId getFeedId() {
        return this.feedId;
    }

    public String toString() {
        return this.feedId + "[" + this.partition + "]";
    }

    public FeedAdapter getFeedAdapter() {
        return this.feedAdapter;
    }

    public AdapterExecutor getAdapterExecutor() {
        return this.adapterExecutor;
    }

    public int getPartition() {
        return this.partition;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone(boolean done) {
        this.done = done;
    }
}

