/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.management;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.ActiveJobNotificationHandler;
import org.apache.asterix.active.ActivityState;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IActiveEventSubscriber;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.asterix.common.metadata.IDataset;
import org.apache.asterix.external.feed.management.ActiveEntityEventsListener;
import org.apache.asterix.external.feed.watch.FeedEventSubscriber;
import org.apache.asterix.external.feed.watch.NoOpSubscriber;
import org.apache.asterix.runtime.utils.AppContextInfo;
import org.apache.hyracks.api.client.IHyracksClientConnection;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobStatus;

public class FeedEventsListener
extends ActiveEntityEventsListener {
    private static final Logger LOGGER = Logger.getLogger(FeedEventsListener.class.getName());
    private final String[] sources;
    private final List<IActiveEventSubscriber> subscribers;
    private int numRegistered;

    public FeedEventsListener(EntityId entityId, List<IDataset> datasets, String[] sources) {
        this.entityId = entityId;
        this.datasets = datasets;
        this.sources = sources;
        this.subscribers = new ArrayList<IActiveEventSubscriber>();
        this.state = ActivityState.STOPPED;
    }

    public synchronized void notify(ActiveEvent event) {
        try {
            switch (event.getEventKind()) {
                case JOB_STARTED: {
                    this.start(event);
                    break;
                }
                case JOB_FINISHED: {
                    this.finish();
                    break;
                }
                case PARTITION_EVENT: {
                    this.partition((ActivePartitionMessage)event.getEventObject());
                    break;
                }
                default: {
                    LOGGER.log(Level.WARNING, "Unhandled feed event notification: " + event);
                }
            }
            this.notifySubscribers(event);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unhandled Exception", e);
        }
    }

    private synchronized void notifySubscribers(ActiveEvent event) {
        this.notifyAll();
        Iterator<IActiveEventSubscriber> it = this.subscribers.iterator();
        while (it.hasNext()) {
            IActiveEventSubscriber subscriber = it.next();
            if (subscriber.done()) {
                it.remove();
                continue;
            }
            subscriber.notify(event);
            if (!subscriber.done()) continue;
            it.remove();
        }
    }

    private void partition(ActivePartitionMessage message) {
        if (message.getEvent() == 0) {
            ++this.numRegistered;
            if (this.numRegistered == this.getSources().length) {
                this.state = ActivityState.STARTED;
            }
        }
    }

    private void finish() throws Exception {
        IHyracksClientConnection hcc = AppContextInfo.INSTANCE.getHcc();
        JobStatus status = hcc.getJobStatus(this.jobId);
        this.state = status.equals((Object)JobStatus.FAILURE) ? ActivityState.FAILED : ActivityState.STOPPED;
        ActiveJobNotificationHandler.INSTANCE.removeListener((IActiveEntityEventsListener)this);
    }

    private void start(ActiveEvent event) {
        this.jobId = event.getJobId();
        this.state = ActivityState.STARTING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IActiveEventSubscriber subscribe(ActivityState state) throws HyracksDataException {
        if (state != ActivityState.STARTED && state != ActivityState.STOPPED) {
            throw new HyracksDataException("Can only wait for STARTED or STOPPED state");
        }
        FeedEventsListener feedEventsListener = this;
        synchronized (feedEventsListener) {
            if (this.state == ActivityState.FAILED) {
                throw new HyracksDataException("Feed has failed");
            }
            if (this.state == state) {
                return NoOpSubscriber.INSTANCE;
            }
            return this.doSubscribe(state);
        }
    }

    private FeedEventSubscriber doSubscribe(ActivityState state) {
        FeedEventSubscriber subscriber = new FeedEventSubscriber(this, state);
        this.subscribers.add(subscriber);
        return subscriber;
    }

    public String[] getSources() {
        return this.sources;
    }
}

