/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.dataflow;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.ArrayDeque;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.log4j.Logger;

public class FrameSpiller {
    private static final Logger LOGGER = Logger.getLogger((String)FrameSpiller.class.getName());
    private static final int FRAMES_PER_FILE = 1024;
    public static final double MAX_SPILL_USED_BEFORE_RESUME = 0.8;
    private final String fileNamePrefix;
    private final ArrayDeque<File> files = new ArrayDeque();
    private final VSizeFrame frame;
    private final int budget;
    private BufferedOutputStream bos;
    private BufferedInputStream bis;
    private File currentWriteFile;
    private File currentReadFile;
    private int currentWriteCount = 0;
    private int currentReadCount = 0;
    private int totalWriteCount = 0;
    private int totalReadCount = 0;
    private int fileCount = 0;

    public FrameSpiller(IHyracksTaskContext ctx, String fileNamePrefix, long budgetInBytes) throws HyracksDataException {
        this.frame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        this.fileNamePrefix = fileNamePrefix;
        this.budget = (int)Math.min(budgetInBytes / (long)ctx.getInitialFrameSize(), Integer.MAX_VALUE);
        if (this.budget <= 0) {
            throw new HyracksDataException("Invalid budget " + budgetInBytes + ". Budget must be larger than 0");
        }
    }

    public void open() throws HyracksDataException {
        try {
            this.currentReadFile = this.currentWriteFile = StoragePathUtil.createFile((String)this.fileNamePrefix, (int)this.fileCount++);
            this.bos = new BufferedOutputStream(new FileOutputStream(this.currentWriteFile));
            this.bis = new BufferedInputStream(new FileInputStream(this.currentReadFile));
        }
        catch (Exception e) {
            LOGGER.fatal((Object)"Unable to create spill file", (Throwable)e);
            throw new HyracksDataException((Throwable)e);
        }
    }

    public boolean switchToMemory() {
        return this.totalWriteCount == this.totalReadCount;
    }

    public int remaining() {
        return this.totalWriteCount - this.totalReadCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteBuffer next() throws HyracksDataException {
        this.frame.reset();
        if (this.totalReadCount == this.totalWriteCount) {
            return null;
        }
        try {
            if (this.currentReadFile == null) {
                if (!this.files.isEmpty()) {
                    this.currentReadFile = this.files.pop();
                    this.bis = new BufferedInputStream(new FileInputStream(this.currentReadFile));
                } else {
                    ByteBuffer byteBuffer = null;
                    return byteBuffer;
                }
            }
            this.bis.read(this.frame.getBuffer().array(), 0, this.frame.getFrameSize());
            byte frameCount = this.frame.getBuffer().array()[0];
            if (frameCount > 1) {
                this.frame.ensureFrameSize(this.frame.getMinSize() * frameCount);
                this.bis.read(this.frame.getBuffer().array(), this.frame.getMinSize(), this.frame.getFrameSize() - this.frame.getMinSize());
            }
            ++this.currentReadCount;
            ++this.totalReadCount;
            if (this.currentReadCount >= 1024) {
                this.currentReadCount = 0;
                this.bis.close();
                Files.delete(this.currentReadFile.toPath());
                if (!this.files.isEmpty()) {
                    this.currentReadFile = this.files.pop();
                    this.bis = new BufferedInputStream(new FileInputStream(this.currentReadFile));
                } else {
                    this.currentReadFile = null;
                }
            }
            ByteBuffer byteBuffer = this.frame.getBuffer();
            return byteBuffer;
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            FrameSpiller frameSpiller = this;
            synchronized (frameSpiller) {
                this.notify();
            }
        }
    }

    public double usedBudget() {
        return (double)(this.totalWriteCount - this.totalReadCount) / (double)this.budget;
    }

    public synchronized boolean spill(ByteBuffer frame) throws HyracksDataException {
        try {
            if (this.totalWriteCount - this.totalReadCount >= this.budget) {
                return false;
            }
            ++this.currentWriteCount;
            ++this.totalWriteCount;
            this.bos.write(frame.array());
            this.bos.flush();
            if (this.currentWriteCount >= 1024) {
                this.bos.close();
                this.currentWriteCount = 0;
                this.currentWriteFile = StoragePathUtil.createFile((String)this.fileNamePrefix, (int)this.fileCount++);
                this.files.add(this.currentWriteFile);
                this.bos = new BufferedOutputStream(new FileOutputStream(this.currentWriteFile));
            }
            return true;
        }
        catch (IOException e) {
            this.close();
            throw new HyracksDataException((Throwable)e);
        }
    }

    public synchronized void close() {
        if (this.bos != null) {
            try {
                this.bos.flush();
                this.bos.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.bis != null) {
            try {
                this.bis.close();
            }
            catch (IOException e) {
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.currentReadFile != null) {
            try {
                Files.deleteIfExists(this.currentReadFile.toPath());
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            }
            this.currentReadFile = null;
        }
        while (!this.files.isEmpty()) {
            File file = this.files.pop();
            try {
                Files.deleteIfExists(file.toPath());
            }
            catch (Exception e) {
                LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.currentWriteCount = 0;
        this.currentReadCount = 0;
        this.totalWriteCount = 0;
        this.totalReadCount = 0;
    }
}

