/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.dataflow;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.exceptions.IExceptionHandler;
import org.apache.asterix.external.util.FeedFrameUtil;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;

public class FeedExceptionHandler
implements IExceptionHandler {
    private static Logger LOGGER = Logger.getLogger(FeedExceptionHandler.class.getName());
    private final IHyracksTaskContext ctx;
    private final FrameTupleAccessor fta;

    public FeedExceptionHandler(IHyracksTaskContext ctx, FrameTupleAccessor fta) {
        this.ctx = ctx;
        this.fta = fta;
    }

    public ByteBuffer handle(HyracksDataException th, ByteBuffer frame) {
        try {
            if (th.getErrorCode() == 2) {
                int tupleIndex;
                block6: {
                    this.fta.reset(frame);
                    tupleIndex = (Integer)th.getParams()[0];
                    try {
                        this.logExceptionCausingTuple(tupleIndex, th);
                    }
                    catch (Exception ex) {
                        ex.addSuppressed(th);
                        if (!LOGGER.isLoggable(Level.WARNING)) break block6;
                        LOGGER.warning("Unable to log exception causing tuple due to..." + ex.getMessage());
                    }
                }
                return FeedFrameUtil.removeBadTuple(this.ctx, tupleIndex, this.fta);
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Unable to handle exception " + exception.getMessage());
            }
            return null;
        }
    }

    private void logExceptionCausingTuple(int tupleIndex, Throwable e) throws HyracksDataException {
        LOGGER.log(Level.WARNING, e.getMessage(), e);
    }
}

