/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.dataflow;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.external.feed.dataflow.FeedFrameCollector;
import org.apache.asterix.external.feed.dataflow.FrameDistributor;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class DistributeFeedFrameWriter
implements IFrameWriter {
    private final EntityId feedId;
    private final FrameDistributor frameDistributor;
    private final IFrameWriter writer;
    private final FeedUtils.FeedRuntimeType feedRuntimeType;
    private final int partition;

    public DistributeFeedFrameWriter(EntityId feedId, IFrameWriter writer, FeedUtils.FeedRuntimeType feedRuntimeType, int partition) throws IOException {
        this.feedId = feedId;
        this.frameDistributor = new FrameDistributor();
        this.feedRuntimeType = feedRuntimeType;
        this.partition = partition;
        this.writer = writer;
    }

    public void subscribe(FeedFrameCollector collector) throws HyracksDataException {
        this.frameDistributor.registerFrameCollector(collector);
    }

    public void unsubscribeFeed(FeedConnectionId connectionId) throws HyracksDataException {
        this.frameDistributor.deregisterFrameCollector(connectionId);
    }

    public void close() throws HyracksDataException {
        try {
            this.frameDistributor.close();
        }
        finally {
            this.writer.close();
        }
    }

    public void fail() throws HyracksDataException {
        this.writer.fail();
    }

    public void nextFrame(ByteBuffer frame) throws HyracksDataException {
        this.frameDistributor.nextFrame(frame);
    }

    public void open() throws HyracksDataException {
        this.writer.open();
    }

    public String toString() {
        return this.feedId.toString() + (Object)((Object)this.feedRuntimeType) + "[" + this.partition + "]";
    }

    public void flush() throws HyracksDataException {
        this.frameDistributor.flush();
    }
}

