/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import org.apache.asterix.external.api.IRawRecord;
import org.apache.asterix.external.api.IRecordDataParser;
import org.apache.asterix.external.api.IRecordReader;
import org.apache.asterix.external.api.ITupleForwarder;
import org.apache.asterix.external.dataflow.AbstractDataFlowController;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.log4j.Logger;

public class RecordDataFlowController<T>
extends AbstractDataFlowController {
    private static final Logger LOGGER = Logger.getLogger((String)RecordDataFlowController.class.getName());
    protected final IRecordDataParser<T> dataParser;
    protected final IRecordReader<? extends T> recordReader;
    protected final int numOfTupleFields;

    public RecordDataFlowController(IHyracksTaskContext ctx, ITupleForwarder tupleForwarder, IRecordDataParser<T> dataParser, IRecordReader<? extends T> recordReader, int numOfTupleFields) {
        super(ctx, tupleForwarder);
        this.dataParser = dataParser;
        this.recordReader = recordReader;
        this.numOfTupleFields = numOfTupleFields;
    }

    @Override
    public void start(IFrameWriter writer) throws HyracksDataException {
        try {
            ArrayTupleBuilder tb = new ArrayTupleBuilder(this.numOfTupleFields);
            this.tupleForwarder.initialize(this.ctx, writer);
            while (this.recordReader.hasNext()) {
                IRawRecord<? extends T> record = this.recordReader.next();
                tb.reset();
                this.dataParser.parse(record, tb.getDataOutput());
                tb.addFieldEndOffset();
                this.appendOtherTupleFields(tb);
                this.tupleForwarder.addTuple(tb);
            }
            this.tupleForwarder.close();
            this.recordReader.close();
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    protected void appendOtherTupleFields(ArrayTupleBuilder tb) throws Exception {
    }
}

