/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.dataflow;

import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.api.IStreamDataParser;
import org.apache.asterix.external.dataflow.AbstractFeedDataFlowController;
import org.apache.asterix.external.dataflow.FeedTupleForwarder;
import org.apache.asterix.external.util.FeedLogManager;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class FeedStreamDataFlowController
extends AbstractFeedDataFlowController {
    private final IStreamDataParser dataParser;
    private final AsterixInputStream stream;

    public FeedStreamDataFlowController(IHyracksTaskContext ctx, FeedTupleForwarder tupleForwarder, FeedLogManager feedLogManager, IStreamDataParser streamParser, AsterixInputStream inputStream) {
        super(ctx, tupleForwarder, feedLogManager, 1);
        this.dataParser = streamParser;
        this.stream = inputStream;
    }

    @Override
    public void start(IFrameWriter writer) throws HyracksDataException {
        try {
            this.tupleForwarder.initialize(this.ctx, writer);
            while (true) {
                this.tb.reset();
                if (!this.dataParser.parse(this.tb.getDataOutput())) {
                    break;
                }
                this.tb.addFieldEndOffset();
                this.tupleForwarder.addTuple(this.tb);
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
        finally {
            this.tupleForwarder.close();
        }
    }

    @Override
    public boolean stop() throws HyracksDataException {
        try {
            if (this.stream.stop()) {
                return true;
            }
            this.stream.close();
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
        return false;
    }

    @Override
    public boolean handleException(Throwable th) {
        boolean handled = true;
        try {
            if (handled &= this.stream.handleException(th)) {
                handled &= this.dataParser.reset(this.stream);
            }
        }
        catch (Exception e) {
            th.addSuppressed(e);
            return false;
        }
        return handled;
    }
}

