/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.data.impl;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.algebricks.data.utils.WriteValueTools;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;

public class IntegerPrinterFactory
implements IPrinterFactory {
    private static final long serialVersionUID = 1L;
    public static final IntegerPrinterFactory INSTANCE = new IntegerPrinterFactory();

    private IntegerPrinterFactory() {
    }

    @Override
    public IPrinter createPrinter() {
        return new IPrinter(){

            @Override
            public void print(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
                int d = IntegerPointable.getInteger((byte[])b, (int)s);
                try {
                    WriteValueTools.writeInt(d, ps);
                }
                catch (IOException e) {
                    throw new HyracksDataException((Throwable)e);
                }
            }

            @Override
            public void init() {
            }
        };
    }
}

